/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.coordinates;

import com.google.common.base.Optional;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.recommenders.coordinates.ProjectCoordinate;

public final class Coordinates {
    private static final Pattern ID_PATTERN = Pattern.compile("[A-Za-z0-9_\\-.]+");

    public static boolean isValidId(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return false;
        }
        return ID_PATTERN.matcher(id).matches();
    }

    public static Optional<ProjectCoordinate> tryNewProjectCoordinate(String groupId, String artifactId, String version) {
        try {
            return Optional.of((Object)new ProjectCoordinate(groupId, artifactId, version));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Optional.absent();
        }
    }

    private Coordinates() {
    }
}

