/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.news.rcp.toolbar;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.commons.lang3.time.DateUtils;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.recommenders.internal.news.rcp.CommonImages;
import org.eclipse.recommenders.internal.news.rcp.FeedDescriptor;
import org.eclipse.recommenders.internal.news.rcp.MessageUtils;
import org.eclipse.recommenders.internal.news.rcp.NewsRcpPreferences;
import org.eclipse.recommenders.internal.news.rcp.PollingResults;
import org.eclipse.recommenders.internal.news.rcp.l10n.Messages;
import org.eclipse.recommenders.internal.news.rcp.notifications.NotificationBridge;
import org.eclipse.recommenders.internal.news.rcp.poll.PollingManager;
import org.eclipse.recommenders.news.api.NewsItem;
import org.eclipse.recommenders.news.api.poll.INewsPollingService;
import org.eclipse.recommenders.news.api.poll.PollingPolicy;
import org.eclipse.recommenders.news.api.poll.PollingRequest;
import org.eclipse.recommenders.news.api.poll.PollingResult;
import org.eclipse.recommenders.news.api.read.IReadItemsStore;
import org.eclipse.swt.widgets.Composite;

public class NewsToolControl {
    private final Action openContextMenuAction = new Action(){

        public void run() {
            if (NewsToolControl.this.toolBarManager != null) {
                NewsToolControl.this.toolBarManager.getContextMenuManager().getMenu().setVisible(true);
            }
        }
    };
    private final NewsRcpPreferences preferences;
    private final INewsPollingService pollingService;
    private final IReadItemsStore readItemsStore;
    private final ECommandService commandService;
    private final EHandlerService handlerService;
    @Nullable
    private ToolBarManager toolBarManager;

    @Inject
    public NewsToolControl(NewsRcpPreferences preferences, INewsPollingService pollingService, IReadItemsStore readItemsStore, ECommandService commandService, EHandlerService handlerService) {
        this.preferences = preferences;
        this.pollingService = pollingService;
        this.readItemsStore = readItemsStore;
        this.commandService = commandService;
        this.handlerService = handlerService;
    }

    @Inject
    public void initialize(NotificationBridge ignored) {
    }

    @Inject
    public void initialize(PollingManager ignored) {
    }

    @PostConstruct
    public void createGui(Composite parent) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800100);
        MenuManager contextMenu = new MenuManager();
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                Map feedContents = NewsToolControl.this.retrieveFeedContents(NewsToolControl.this.preferences.getFeedDescriptors());
                if (feedContents.isEmpty()) {
                    PlaceholderAction allFeedsDisabledAction = new PlaceholderAction(Messages.ACTION_LABEL_ALL_FEEDS_DISABLED);
                    menu.add((IAction)allFeedsDisabledAction);
                } else {
                    for (Map.Entry<FeedDescriptor, PollingResult> entry : this.sortByName(feedContents.entrySet())) {
                        MenuManager feedMenu = NewsToolControl.this.createFeedMenu(entry.getKey(), entry.getValue());
                        menu.add((IContributionItem)feedMenu);
                    }
                }
                menu.add((IContributionItem)new Separator());
                ExecuteCommandAction pollNowAction = new ExecuteCommandAction(Messages.ACTION_LABEL_POLL_NOW, CommonImages.REFRESH, "org.eclipse.recommenders.news.rcp.command.pollNewsFeeds", Collections.emptyMap());
                menu.add((IAction)pollNowAction);
                ExecuteCommandAction markAsReadAction = new ExecuteCommandAction(Messages.ACTION_LABEL_MARK_AS_READ, null, "org.eclipse.recommenders.news.rcp.command.readNewsItems", (Map)ImmutableMap.of((Object)"org.eclipse.recommenders.news.rcp.commandParameter.newsItems", (Object)NewsToolControl.getAllItems(feedContents.values())));
                menu.add((IAction)markAsReadAction);
                menu.add((IContributionItem)new Separator());
                ExecuteCommandAction preferencesAction = new ExecuteCommandAction(Messages.ACTION_LABEL_PREFERENCES, null, "org.eclipse.ui.window.preferences", (Map)ImmutableMap.of((Object)"preferencePageId", (Object)"org.eclipse.recommenders.news.rcp.preferencePages.news"));
                menu.add((IAction)preferencesAction);
            }

            private Iterable<Map.Entry<FeedDescriptor, PollingResult>> sortByName(Set<Map.Entry<FeedDescriptor, PollingResult>> entrySet) {
                return Ordering.natural().onResultOf((Function)new Function<Map.Entry<FeedDescriptor, PollingResult>, String>(){

                    public String apply(Map.Entry<FeedDescriptor, PollingResult> entry) {
                        return entry.getKey().getName();
                    }
                }).sortedCopy(entrySet);
            }
        });
        toolBarManager.setContextMenuManager(contextMenu);
        this.refreshUnreadItemsStatus(this.openContextMenuAction);
        toolBarManager.add((IAction)this.openContextMenuAction);
        toolBarManager.createControl(parent);
        this.toolBarManager = toolBarManager;
    }

    private MenuManager createFeedMenu(FeedDescriptor feed, PollingResult result) {
        List<NewsItem> items = PollingResults.getAllNewsItems(result, 20);
        int numberOfUnreadMessages = this.getNumberOfUnreadMessages(items);
        String feedLabel = numberOfUnreadMessages == 0 ? MessageFormat.format(Messages.LABEL_READ_FEED, NewsToolControl.preserveAtSign(feed.getName())) : MessageFormat.format(Messages.LABEL_UNREAD_FEED, NewsToolControl.preserveAtSign(feed.getName()), numberOfUnreadMessages);
        MenuManager feedMenu = new MenuManager(feedLabel);
        if (result.getStatus().equals((Object)PollingResult.Status.NOT_DOWNLOADED)) {
            feedMenu.add((IAction)new PlaceholderAction(Messages.FEED_NOT_POLLED_YET));
        } else if (result.getAllNewsItems().isEmpty()) {
            feedMenu.add((IAction)new PlaceholderAction(Messages.FEED_EMPTY));
        } else {
            List<List<NewsItem>> ageGroups = NewsToolControl.splitMessagesByAge(items);
            ImmutableList labels = ImmutableList.of((Object)Messages.ACTION_LABEL_TODAY, (Object)Messages.ACTION_LABEL_YESTERDAY, (Object)Messages.ACTION_LABEL_THIS_WEEK, (Object)Messages.ACTION_LABEL_LAST_WEEK, (Object)Messages.ACTION_LABEL_THIS_MONTH, (Object)Messages.ACTION_LABEL_LAST_MONTH, (Object)Messages.ACTION_LABEL_THIS_YEAR, (Object)Messages.ACTION_LABEL_OLDER_ENTRIES, (Object)Messages.ACTION_LABEL_UNDETERMINED_ENTRIES);
            int i = 0;
            while (i < MessageUtils.MessageAge.values().length) {
                List<NewsItem> ageGroup = ageGroups.get(i);
                if (!ageGroup.isEmpty()) {
                    feedMenu.add((IContributionItem)new Separator());
                    feedMenu.add((IAction)new PlaceholderAction((String)labels.get(i)));
                    for (NewsItem item : ageGroup) {
                        String itemLabel = this.readItemsStore.isRead(item) ? MessageFormat.format(Messages.LABEL_READ_ITEM, NewsToolControl.preserveAtSign(item.getTitle())) : MessageFormat.format(Messages.LABEL_UNREAD_ITEM, NewsToolControl.preserveAtSign(item.getTitle()));
                        ExecuteCommandAction readNewsItemAction = new ExecuteCommandAction(itemLabel, null, "org.eclipse.recommenders.news.rcp.command.readNewsItems", (Map)ImmutableMap.of((Object)"org.eclipse.recommenders.news.rcp.commandParameter.newsItems", Collections.singleton(item), (Object)"org.eclipse.recommenders.news.rcp.commandParameter.openBrowser", (Object)true));
                        feedMenu.add((IAction)readNewsItemAction);
                    }
                }
                ++i;
            }
            feedMenu.add((IContributionItem)new Separator());
            ExecuteCommandAction markAsReadAction = new ExecuteCommandAction(Messages.ACTION_LABEL_MARK_AS_READ, null, "org.eclipse.recommenders.news.rcp.command.readNewsItems", (Map)ImmutableMap.of((Object)"org.eclipse.recommenders.news.rcp.commandParameter.newsItems", items));
            feedMenu.add((IAction)markAsReadAction);
        }
        return feedMenu;
    }

    private int getNumberOfUnreadMessages(Collection<NewsItem> collection) {
        int numberOfUnreadMessages = 0;
        for (NewsItem item : collection) {
            if (this.readItemsStore.isRead(item)) continue;
            ++numberOfUnreadMessages;
        }
        return numberOfUnreadMessages;
    }

    private static String preserveAtSign(String actionText) {
        String atSign = "@";
        if (actionText.contains(atSign)) {
            return String.valueOf(actionText) + atSign;
        }
        return actionText;
    }

    @Inject
    @Optional
    public void handlePollingResults(@UIEventTopic(value="org_eclipse_recommenders_news/pollingResults") Collection<PollingResult> ignored) {
        this.refreshUnreadItemsStatus(this.openContextMenuAction);
    }

    @Inject
    @Optional
    public void handleNewsItemsRead(@UIEventTopic(value="org_eclipse_recommenders_news/newsItemsRead") Collection<NewsItem> ignored) {
        this.refreshUnreadItemsStatus(this.openContextMenuAction);
    }

    private void refreshUnreadItemsStatus(Action action) {
        int numberOfUnreadMessages = this.getNumberOfUnreadMessages(NewsToolControl.getAllItems(this.retrieveFeedContents(this.preferences.getFeedDescriptors()).values()));
        boolean hasUnreadItems = numberOfUnreadMessages > 0;
        action.setImageDescriptor(hasUnreadItems ? CommonImages.RSS_ACTIVE : CommonImages.RSS_INACTIVE);
        action.setToolTipText(MessageFormat.format(Messages.ACTION_TOOLTIP_NEWS, numberOfUnreadMessages));
    }

    @PreDestroy
    public void dispose() {
        if (this.toolBarManager != null) {
            this.toolBarManager.dispose();
        }
    }

    private Map<FeedDescriptor, PollingResult> retrieveFeedContents(List<FeedDescriptor> feeds) {
        Collection enabledFeeds = Collections2.filter(feeds, (Predicate)new Predicate<FeedDescriptor>(){

            public boolean apply(FeedDescriptor feed) {
                return feed.isEnabled();
            }
        });
        if (enabledFeeds.isEmpty()) {
            return Collections.emptyMap();
        }
        Collection requests = Collections2.transform((Collection)enabledFeeds, (Function)new Function<FeedDescriptor, PollingRequest>(){

            public PollingRequest apply(FeedDescriptor feed) {
                return new PollingRequest(feed.getUri(), PollingPolicy.never());
            }
        });
        HashMap<FeedDescriptor, PollingResult> feedContents = new HashMap<FeedDescriptor, PollingResult>();
        Collection results = this.pollingService.poll(requests, null);
        Iterator enabledFeedsIterator = enabledFeeds.iterator();
        Iterator resultsIterator = results.iterator();
        while (enabledFeedsIterator.hasNext() && resultsIterator.hasNext()) {
            FeedDescriptor feed = (FeedDescriptor)enabledFeedsIterator.next();
            PollingResult result = (PollingResult)resultsIterator.next();
            feedContents.put(feed, result);
        }
        return feedContents;
    }

    private static List<List<NewsItem>> splitMessagesByAge(List<NewsItem> messages) {
        Locale locale = Locale.getDefault();
        Calendar calendar = Calendar.getInstance(locale);
        ArrayList<List<NewsItem>> result = new ArrayList<List<NewsItem>>();
        int i = 0;
        while (i < MessageUtils.MessageAge.values().length) {
            ArrayList list = new ArrayList();
            result.add(list);
            ++i;
        }
        if (messages == null) {
            return result;
        }
        Date today = DateUtils.truncate((Date)calendar.getTime(), (int)5);
        for (NewsItem message : messages) {
            MessageUtils.MessageAge[] messageAgeArray = MessageUtils.MessageAge.values();
            int n = messageAgeArray.length;
            int n2 = 0;
            while (n2 < n) {
                MessageUtils.MessageAge messageAge = messageAgeArray[n2];
                if (message.getDate().after(MessageUtils.getPeriodStartDate(messageAge, today, locale)) || message.getDate().equals(MessageUtils.getPeriodStartDate(messageAge, today, locale))) {
                    ((List)result.get(messageAge.getIndex())).add(message);
                    break;
                }
                ++n2;
            }
            if (!message.getDate().before(MessageUtils.getPeriodStartDate(MessageUtils.MessageAge.OLDER, today, locale))) continue;
            ((List)result.get(MessageUtils.MessageAge.OLDER.getIndex())).add(message);
        }
        return result;
    }

    private static Collection<NewsItem> getAllItems(Collection<PollingResult> results) {
        ArrayList<NewsItem> allItems = new ArrayList<NewsItem>();
        for (PollingResult result : results) {
            allItems.addAll(PollingResults.getAllNewsItems(result, 20));
        }
        return allItems;
    }

    private final class ExecuteCommandAction
    extends Action {
        private final ParameterizedCommand command;

        private ExecuteCommandAction(String text, ImageDescriptor image, String commandId, Map<String, Object> commandParameters) {
            super(text, image);
            this.command = NewsToolControl.this.commandService.createCommand(commandId, commandParameters);
        }

        public void run() {
            NewsToolControl.this.handlerService.executeHandler(this.command);
        }

        public boolean isEnabled() {
            return NewsToolControl.this.handlerService.canExecute(this.command);
        }
    }

    private static final class PlaceholderAction
    extends Action {
        private PlaceholderAction(String label) {
            super(label);
            this.setEnabled(false);
        }
    }
}

