/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.util.SortedSet;
import org.eclipse.sapphire.InitialValueService;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.internal.ValueSnapshot;
import org.eclipse.sapphire.services.FactsService;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;

public final class InitialValueFactsService
extends FactsService {
    @Text(value="Initial value is {0}")
    private static LocalizableText statement;

    static {
        LocalizableText.init(InitialValueFactsService.class);
    }

    @Override
    protected void facts(SortedSet<String> facts) {
        Value value = this.context(Value.class);
        InitialValueService initialValueService = value.service(InitialValueService.class);
        String text = initialValueService.value();
        if (text != null && text.trim().length() > 0) {
            facts.add(statement.format(new ValueSnapshot(value.definition(), text)));
        }
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            Property property = context.find(Property.class);
            return property != null && property.service(InitialValueService.class) != null;
        }
    }
}

