/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.dialect.description;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionQueryProvider;
import org.eclipse.sirius.viewpoint.Messages;

public class InterpretedExpressionQueryProviderRegistry {
    public static final String EXTENSION_POINT = "org.eclipse.sirius.interpretedExpressionQueryProvider";
    public static final String CLASS_ATTRIBUTE = "class";
    private final IExtensionRegistry registry;
    private final Plugin context;
    private final Collection<IInterpretedExpressionQueryProvider> entries;
    private final IRegistryEventListener listener = new IRegistryEventListener(){

        public void added(IExtension[] extensions) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement elem = iConfigurationElementArray[n4];
                    InterpretedExpressionQueryProviderRegistry.this.register(elem);
                    ++n4;
                }
                ++n2;
            }
        }

        public void removed(IExtension[] extensions) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement elem = iConfigurationElementArray[n4];
                    InterpretedExpressionQueryProviderRegistry.this.unregister(elem);
                    ++n4;
                }
                ++n2;
            }
        }

        public void added(IExtensionPoint[] extensionPoints) {
        }

        public void removed(IExtensionPoint[] extensionPoints) {
        }
    };

    public InterpretedExpressionQueryProviderRegistry(IExtensionRegistry registry, Plugin context) {
        this.registry = (IExtensionRegistry)Preconditions.checkNotNull((Object)registry);
        this.context = context;
        this.entries = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    public void init() {
        this.registry.addListener(this.listener, EXTENSION_POINT);
        IExtension[] initialExtensions = this.registry.getExtensionPoint(EXTENSION_POINT).getExtensions();
        this.listener.added(initialExtensions);
    }

    public void dispose() {
        this.registry.removeListener(this.listener);
        this.entries.clear();
    }

    public Collection<IInterpretedExpressionQueryProvider> getEntries() {
        return Collections.unmodifiableList(Lists.newArrayList(this.entries));
    }

    private void register(IConfigurationElement elem) {
        try {
            Object executableExtension = elem.createExecutableExtension(CLASS_ATTRIBUTE);
            if (executableExtension instanceof IInterpretedExpressionQueryProvider) {
                this.entries.add((IInterpretedExpressionQueryProvider)executableExtension);
            }
        }
        catch (CoreException e) {
            String message = MessageFormat.format(Messages.InterpretedExpressionQueryProviderRegistry_instanciationError, elem.getAttribute(CLASS_ATTRIBUTE));
            this.context.getLog().log((IStatus)new Status(4, this.context.getBundle().getSymbolicName(), message, (Throwable)e));
        }
    }

    private void unregister(IConfigurationElement elem) {
        String className = elem.getAttribute("actionClass");
        Iterator<IInterpretedExpressionQueryProvider> iter = this.entries.iterator();
        while (iter.hasNext()) {
            IInterpretedExpressionQueryProvider provider = iter.next();
            if (!Objects.equal((Object)className, (Object)provider.getClass().getName())) continue;
            iter.remove();
        }
    }
}

