/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.viewpoint.Messages;

public class SaveSessionJob
extends Job {
    public static final String FAMILY = "org.eclipse.sirius.saveSessionJob";
    private Session session;

    public SaveSessionJob(Session session) {
        super(Messages.SaveSessionJob_sessionSavingMsg);
        this.setSystem(true);
        this.session = session;
    }

    public IStatus run(IProgressMonitor monitor) {
        IStatus result = Status.OK_STATUS;
        try {
            monitor.beginTask(Messages.SaveSessionJob_sessionSavingMsg, -1);
            if (this.session != null && this.session.isOpen() && SessionStatus.DIRTY == this.session.getStatus()) {
                result = this.performSave(monitor);
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
            this.session = null;
        }
        return result;
    }

    protected IStatus performSave(IProgressMonitor monitor) {
        if (this.session instanceof DAnalysisSessionImpl) {
            boolean exclusiveSetting = ((DAnalysisSessionImpl)this.session).isSaveInExclusiveTransaction();
            ((DAnalysisSessionImpl)this.session).setSaveInExclusiveTransaction(false);
            try {
                this.session.save(monitor);
            }
            finally {
                ((DAnalysisSessionImpl)this.session).setSaveInExclusiveTransaction(exclusiveSetting);
            }
        } else {
            this.session.save(monitor);
        }
        return Status.OK_STATUS;
    }

    public boolean belongsTo(Object family) {
        return FAMILY.equals(family);
    }
}

