/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.internal.tmf.core.TmfCoreTracer;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisOutput;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisParameterProvider;
import org.eclipse.tracecompass.tmf.core.analysis.Messages;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAnalysisManager;
import org.eclipse.tracecompass.tmf.core.analysis.requirements.TmfAbstractAnalysisRequirement;
import org.eclipse.tracecompass.tmf.core.component.TmfComponent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.project.model.ITmfPropertiesProvider;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfStartAnalysisSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;

@NonNullByDefault
public abstract class TmfAbstractAnalysisModule
extends TmfComponent
implements IAnalysisModule,
ITmfPropertiesProvider {
    private static final Logger LOGGER = TraceCompassLog.getLogger(TmfAbstractAnalysisModule.class);
    private @Nullable String fId;
    private boolean fAutomatic = false;
    private boolean fStarted = false;
    private volatile @Nullable ITmfTrace fTrace;
    private final Map<String, @Nullable Object> fParameters = new HashMap<String, Object>();
    private final List<String> fParameterNames = new ArrayList<String>();
    private final List<IAnalysisOutput> fOutputs = new ArrayList<IAnalysisOutput>();
    private Set<IAnalysisParameterProvider> fParameterProviders = new HashSet<IAnalysisParameterProvider>();
    private @Nullable Job fJob = null;
    private int fDependencyLevel = 0;
    private final Object syncObj = new Object();
    private CountDownLatch fFinishedLatch = new CountDownLatch(0);
    private boolean fAnalysisCancelled = false;
    private @Nullable Throwable fFailureCause = null;

    @Override
    public boolean isAutomatic() {
        return this.fAutomatic;
    }

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    @Override
    public void setId(String id) {
        this.fId = id;
    }

    @Override
    public String getId() {
        String id = this.fId;
        if (id == null) {
            id = this.getClass().getCanonicalName();
            if (id == null) {
                id = this.getClass().getName();
            }
            this.fId = id;
        }
        return id;
    }

    @Override
    public void setAutomatic(boolean auto) {
        this.fAutomatic = auto;
    }

    @Override
    public boolean setTrace(ITmfTrace trace) throws TmfAnalysisException {
        if (this.fTrace != null) {
            throw new TmfAnalysisException(NLS.bind((String)Messages.TmfAbstractAnalysisModule_TraceSetMoreThanOnce, (Object)this.getName()));
        }
        TmfCoreTracer.traceAnalysis(this.getId(), trace, "setting trace for analysis");
        this.fTrace = trace;
        if (!this.canExecute(trace)) {
            this.fTrace = null;
            return false;
        }
        this.fParameterProviders = TmfAnalysisManager.getParameterProvidersForModule(this, trace);
        for (IAnalysisParameterProvider provider : this.fParameterProviders) {
            TmfCoreTracer.traceAnalysis(this.getId(), trace, "registered to parameter provider " + provider.getName());
            provider.registerModule(this);
        }
        this.resetAnalysis();
        this.fStarted = false;
        return true;
    }

    public @Nullable ITmfTrace getTrace() {
        return this.fTrace;
    }

    @Override
    public void addParameter(String name) {
        this.fParameterNames.add(name);
    }

    @Override
    public synchronized void setParameter(String name, @Nullable Object value) {
        if (!this.fParameterNames.contains(name)) {
            throw new RuntimeException(NLS.bind((String)Messages.TmfAbstractAnalysisModule_InvalidParameter, (Object)name, (Object)this.getName()));
        }
        Object oldValue = this.fParameters.get(name);
        this.fParameters.put(name, value);
        if (value != null && !value.equals(oldValue)) {
            this.parameterChanged(name);
        }
    }

    @Override
    public synchronized void notifyParameterChanged(String name) {
        if (!this.fParameterNames.contains(name)) {
            throw new RuntimeException(NLS.bind((String)Messages.TmfAbstractAnalysisModule_InvalidParameter, (Object)name, (Object)this.getName()));
        }
        Object oldValue = this.fParameters.get(name);
        Object value = this.getParameter(name);
        if (value != null && !value.equals(oldValue)) {
            this.parameterChanged(name);
        }
    }

    protected void parameterChanged(String name) {
    }

    @Override
    public synchronized @Nullable Object getParameter(String name) {
        Object paramValue = this.fParameters.get(name);
        if (paramValue == null && this.fTrace != null) {
            for (IAnalysisParameterProvider provider : this.fParameterProviders) {
                paramValue = provider.getParameter(name);
                if (paramValue != null) break;
            }
        }
        return paramValue;
    }

    @Override
    public boolean canExecute(ITmfTrace trace) {
        for (TmfAbstractAnalysisRequirement requirement : this.getAnalysisRequirements()) {
            if (requirement.test(trace)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetAnalysis() {
        TmfCoreTracer.traceAnalysis(this.getId(), this.getTrace(), "reset: ready for execution");
        Object object = this.syncObj;
        synchronized (object) {
            this.fFinishedLatch.countDown();
            this.fFinishedLatch = new CountDownLatch(1);
        }
    }

    protected abstract boolean executeAnalysis(IProgressMonitor var1) throws TmfAnalysisException;

    protected abstract void canceling();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAnalysisCompleted() {
        Object object = this.syncObj;
        synchronized (object) {
            this.fStarted = false;
            this.fJob = null;
            this.fFinishedLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void cancel() {
        Object object = this.syncObj;
        synchronized (object) {
            Job job = this.fJob;
            if (job != null) {
                TmfCoreTracer.traceAnalysis(this.getId(), this.getTrace(), "cancelled by application");
                job.cancel();
                this.fAnalysisCancelled = true;
                this.setAnalysisCompleted();
            }
            this.fStarted = false;
        }
    }

    @Override
    public final void fail(Throwable cause) {
        this.fFailureCause = cause;
        this.onFail();
    }

    protected void onFail() {
    }

    @Override
    public void dispose() {
        super.dispose();
        this.cancel();
    }

    protected Iterable<IAnalysisModule> getDependentAnalyses() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public int getDependencyLevel() {
        return this.fDependencyLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void execute(final ITmfTrace trace) {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            final TraceCompassLogUtils.FlowScopeLog analysisLog = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "TmfAbstractAnalysis:scheduling", new Object[]{"name", this.getName()}).setCategory(this.getId()).build();
            try {
                if (this.fFinishedLatch.getCount() == 0L) {
                    TmfCoreTracer.traceAnalysis(this.getId(), this.getTrace(), "already executed");
                    return;
                }
                Object object = this.syncObj;
                synchronized (object) {
                    if (this.fStarted) {
                        TmfCoreTracer.traceAnalysis(this.getId(), this.getTrace(), "already started, not starting again");
                        return;
                    }
                    {
                        this.fStarted = true;
                    }
                }
                final Iterable<IAnalysisModule> dependentAnalyses = this.getDependentAnalyses();
                int depLevel = 0;
                Iterator<IAnalysisModule> iterator = dependentAnalyses.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        this.fDependencyLevel = depLevel;
                        String jobName = (String)NonNullUtils.checkNotNull((Object)NLS.bind((String)Messages.TmfAbstractAnalysisModule_RunningAnalysis, (Object)this.getName()));
                        this.fJob = new Job(jobName){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Unable to fully structure code
                             */
                            protected @Nullable IStatus run(@Nullable IProgressMonitor monitor) {
                                var2_2 = null;
                                var3_4 = null;
                                try {
                                    block33: {
                                        jobLog = new TraceCompassLogUtils.FlowScopeLogBuilder(TmfAbstractAnalysisModule.access$0(), Level.FINE, "TmfAbstractAnalysis:executing", new Object[0]).setParentScope(analysisLog).build();
                                        mon = monitor;
                                        if (mon == null) {
                                            mon = new NullProgressMonitor();
                                        }
                                        try {
                                            mon.beginTask("", -1);
                                            TmfAbstractAnalysisModule.this.broadcast(new TmfStartAnalysisSignal((Object)TmfAbstractAnalysisModule.this, TmfAbstractAnalysisModule.this));
                                            TmfCoreTracer.traceAnalysis(TmfAbstractAnalysisModule.this.getId(), TmfAbstractAnalysisModule.this.getTrace(), "started");
                                            TmfAbstractAnalysisModule.access$3(TmfAbstractAnalysisModule.this, TmfAbstractAnalysisModule.this.executeAnalysis(mon) == false);
                                            for (IAnalysisModule module : dependentAnalyses) {
                                                module.waitForCompletion(mon);
                                            }
                                            TmfCoreTracer.traceAnalysis(TmfAbstractAnalysisModule.this.getId(), TmfAbstractAnalysisModule.this.getTrace(), "finished");
                                        }
                                        catch (TmfAnalysisException e) {
                                            Activator.logError("Error executing analysis with trace " + trace.getName(), e);
                                            var10_12 = TmfAbstractAnalysisModule.access$1(TmfAbstractAnalysisModule.this);
                                            synchronized (var10_12) {
                                                mon.done();
                                                TmfAbstractAnalysisModule.access$2(TmfAbstractAnalysisModule.this);
                                            }
                                            TmfTraceManager.refreshSupplementaryFiles(trace);
                                            break block33;
                                        }
                                        catch (Exception e) {
                                            try {
                                                Activator.logError("Unexpected error executing analysis with trace " + trace.getName(), e);
                                                TmfAbstractAnalysisModule.this.fail(e);
                                                TmfAbstractAnalysisModule.this.resetAnalysis();
                                                var9_16 = new Status(4, "org.eclipse.tracecompass.tmf.core", 0, "Exception executing analysis", (Throwable)e);
                                            }
                                            catch (Throwable var8_17) {
                                                var10_14 = TmfAbstractAnalysisModule.access$1(TmfAbstractAnalysisModule.this);
                                                synchronized (var10_14) {
                                                    mon.done();
                                                    TmfAbstractAnalysisModule.access$2(TmfAbstractAnalysisModule.this);
                                                }
                                                TmfTraceManager.refreshSupplementaryFiles(trace);
                                                throw var8_17;
                                            }
                                            var10_13 = TmfAbstractAnalysisModule.access$1(TmfAbstractAnalysisModule.this);
                                            synchronized (var10_13) {
                                                mon.done();
                                                TmfAbstractAnalysisModule.access$2(TmfAbstractAnalysisModule.this);
                                            }
                                            TmfTraceManager.refreshSupplementaryFiles(trace);
                                            if (jobLog != null) {
                                                jobLog.close();
                                            }
                                            return var9_16;
                                        }
                                        var10_15 = TmfAbstractAnalysisModule.access$1(TmfAbstractAnalysisModule.this);
                                        synchronized (var10_15) {
                                            mon.done();
                                            TmfAbstractAnalysisModule.access$2(TmfAbstractAnalysisModule.this);
                                        }
                                        TmfTraceManager.refreshSupplementaryFiles(trace);
                                    }
                                    if (TmfAbstractAnalysisModule.access$4(TmfAbstractAnalysisModule.this)) ** GOTO lbl75
                                    {
                                        return Status.OK_STATUS;
lbl75:
                                        // 1 sources

                                        TmfAbstractAnalysisModule.this.resetAnalysis();
                                        v4 = Status.CANCEL_STATUS;
                                    }
                                    try {
                                        return v4;
                                    }
                                    catch (Throwable var2_3) {
                                        throw var2_3;
                                    }
                                    finally {
                                        if (jobLog != null) {
                                            jobLog.close();
                                        }
                                    }
                                }
                                catch (Throwable var3_5) {
                                    if (var2_2 == null) {
                                        var2_2 = var3_5;
                                    } else if (var2_2 != var3_5) {
                                        var2_2.addSuppressed(var3_5);
                                    }
                                    throw var2_2;
                                }
                            }

                            protected void canceling() {
                                TmfCoreTracer.traceAnalysis(TmfAbstractAnalysisModule.this.getId(), TmfAbstractAnalysisModule.this.getTrace(), "job cancelled");
                                TmfAbstractAnalysisModule.this.canceling();
                            }
                        };
                        this.fJob.schedule();
                        return;
                    }
                    IAnalysisModule module = iterator.next();
                    module.schedule();
                    depLevel += module.getDependencyLevel() + 1;
                }
            }
            finally {
                if (analysisLog == null) return;
                analysisLog.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStatus schedule() {
        Object object = this.syncObj;
        synchronized (object) {
            ITmfTrace trace = this.getTrace();
            if (trace == null) {
                return new Status(4, "org.eclipse.tracecompass.tmf.core", String.format("No trace specified for analysis %s", this.getName()));
            }
            TmfCoreTracer.traceAnalysis(this.getId(), this.getTrace(), "scheduled");
            this.execute(trace);
        }
        return Status.OK_STATUS;
    }

    @Override
    public Iterable<IAnalysisOutput> getOutputs() {
        return this.fOutputs;
    }

    @Override
    public void registerOutput(IAnalysisOutput output) {
        if (!this.fOutputs.contains(output)) {
            this.fOutputs.add(output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForCompletion() {
        boolean started;
        CountDownLatch finishedLatch;
        Object object = this.syncObj;
        synchronized (object) {
            finishedLatch = this.fFinishedLatch;
            started = this.fStarted;
        }
        try {
            if (started) {
                finishedLatch.await();
            }
        }
        catch (InterruptedException e) {
            Activator.logError("Error while waiting for module completion", e);
        }
        return !this.fAnalysisCancelled && this.fFailureCause == null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean waitForCompletion(IProgressMonitor monitor) {
        try {
            while (!this.fFinishedLatch.await(500L, TimeUnit.MILLISECONDS)) {
                if (!this.fAnalysisCancelled && !monitor.isCanceled()) continue;
                this.fAnalysisCancelled = true;
                return false;
            }
            return !this.fAnalysisCancelled && this.fFailureCause == null;
        }
        catch (InterruptedException e) {
            Activator.logError("Error while waiting for module completion", e);
        }
        return !this.fAnalysisCancelled && this.fFailureCause == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        Object object = this.syncObj;
        synchronized (object) {
            if (signal.getTrace() == this.fTrace) {
                this.cancel();
                this.fTrace = null;
            }
        }
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        if (signal.getTrace() == this.fTrace) {
            for (IAnalysisParameterProvider provider : this.fParameterProviders) {
                provider.registerModule(this);
            }
        }
    }

    protected String getFullHelpText() {
        return NonNullUtils.nullToEmptyString((Object)NLS.bind((String)Messages.TmfAbstractAnalysisModule_AnalysisModule, (Object)this.getName()));
    }

    protected String getShortHelpText(ITmfTrace trace) {
        return NonNullUtils.nullToEmptyString((Object)NLS.bind((String)Messages.TmfAbstractAnalysisModule_AnalysisForTrace, (Object)this.getName(), (Object)trace.getName()));
    }

    protected String getTraceCannotExecuteHelpText(ITmfTrace trace) {
        StringBuilder builder = new StringBuilder();
        builder.append(NLS.bind((String)Messages.TmfAbstractAnalysisModule_AnalysisCannotExecute, (Object)this.getName()));
        for (TmfAbstractAnalysisRequirement requirement : this.getAnalysisRequirements()) {
            if (requirement.test(trace)) continue;
            builder.append("\n\n");
            builder.append(NLS.bind((String)Messages.TmfAnalysis_RequirementNotFulfilled, (Object)((Object)requirement.getPriorityLevel())));
            builder.append("\n");
            builder.append(NLS.bind((String)Messages.TmfAnalysis_RequirementMandatoryValues, requirement.getValues()));
            Set<String> information = requirement.getInformation();
            if (information.isEmpty()) continue;
            builder.append("\n");
            builder.append(NLS.bind((String)Messages.TmfAnalysis_RequirementInformation, information));
        }
        return builder.toString();
    }

    @Override
    public String getHelpText() {
        return this.getFullHelpText();
    }

    @Override
    public String getHelpText(ITmfTrace trace) {
        String text = this.getShortHelpText(trace);
        if (!this.canExecute(trace)) {
            text = String.valueOf(text) + "\n\n" + this.getTraceCannotExecuteHelpText(trace);
        }
        return text;
    }

    @Override
    public Iterable<TmfAbstractAnalysisRequirement> getAnalysisRequirements() {
        return Collections.EMPTY_SET;
    }

    @Override
    public Map<@NonNull String, @NonNull String> getProperties() {
        HashMap<@NonNull String, @NonNull String> properties = new HashMap<String, String>();
        properties.put((String)NonNullUtils.checkNotNull((Object)Messages.TmfAbstractAnalysisModule_LabelId), this.getId());
        return properties;
    }

    static /* synthetic */ Logger access$0() {
        return LOGGER;
    }

    static /* synthetic */ Object access$1(TmfAbstractAnalysisModule tmfAbstractAnalysisModule) {
        return tmfAbstractAnalysisModule.syncObj;
    }

    static /* synthetic */ void access$2(TmfAbstractAnalysisModule tmfAbstractAnalysisModule) {
        tmfAbstractAnalysisModule.setAnalysisCompleted();
    }

    static /* synthetic */ void access$3(TmfAbstractAnalysisModule tmfAbstractAnalysisModule, boolean bl) {
        tmfAbstractAnalysisModule.fAnalysisCancelled = bl;
    }

    static /* synthetic */ boolean access$4(TmfAbstractAnalysisModule tmfAbstractAnalysisModule) {
        return tmfAbstractAnalysisModule.fAnalysisCancelled;
    }
}

