/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.check;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.CheckOperationExecutor;
import org.eclipse.viatra.query.runtime.localsearch.operations.IPatternMatcherOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.util.CallInformation;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryResultProvider;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;

public class BinaryTransitiveClosureCheck
implements ISearchOperation,
IPatternMatcherOperation {
    private final CallInformation information;
    private IQueryResultProvider matcher;
    private final int sourcePosition;
    private final int targetPosition;
    private final boolean reflexive;

    public BinaryTransitiveClosureCheck(CallInformation information, int sourcePosition, int targetPosition, boolean reflexive) {
        this.sourcePosition = sourcePosition;
        this.targetPosition = targetPosition;
        this.information = information;
        this.reflexive = reflexive;
    }

    @Override
    public ISearchOperation.ISearchOperationExecutor createExecutor() {
        return new Executor();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    @Override
    public String toString(Function<Integer, String> variableMapping) {
        String c = this.information.toString(variableMapping);
        int p = c.indexOf(40);
        String modifier = this.reflexive ? "*" : "+";
        return "check     find " + c.substring(0, p) + modifier + c.substring(p);
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Arrays.asList(this.sourcePosition, this.targetPosition);
    }

    @Override
    public CallInformation getCallInformation() {
        return this.information;
    }

    private class Executor
    extends CheckOperationExecutor {
        private Executor() {
        }

        @Override
        public void onInitialize(MatchingFrame frame, ISearchContext context) {
            super.onInitialize(frame, context);
            BinaryTransitiveClosureCheck.this.matcher = context.getMatcher(BinaryTransitiveClosureCheck.this.information.getReference());
        }

        @Override
        protected boolean check(MatchingFrame frame, ISearchContext context) {
            if (this.checkReflexive(frame)) {
                return true;
            }
            Object targetValue = frame.get(BinaryTransitiveClosureCheck.this.targetPosition);
            LinkedList<Object> sourcesToEvaluate = new LinkedList<Object>();
            sourcesToEvaluate.add(frame.get(BinaryTransitiveClosureCheck.this.sourcePosition));
            HashSet sourceEvaluated = new HashSet();
            Object[] mappedFrame = new Object[2];
            while (!sourcesToEvaluate.isEmpty()) {
                Object currentValue = sourcesToEvaluate.poll();
                sourceEvaluated.add(currentValue);
                mappedFrame[0] = currentValue;
                for (Tuple match : () -> BinaryTransitiveClosureCheck.this.matcher.getAllMatches(mappedFrame).iterator()) {
                    Object foundTarget = match.get(1);
                    if (targetValue.equals(foundTarget)) {
                        return true;
                    }
                    if (sourceEvaluated.contains(foundTarget)) continue;
                    sourcesToEvaluate.add(foundTarget);
                }
            }
            return false;
        }

        protected boolean checkReflexive(MatchingFrame frame) {
            return BinaryTransitiveClosureCheck.this.reflexive && Objects.equals(frame.get(BinaryTransitiveClosureCheck.this.sourcePosition), frame.get(BinaryTransitiveClosureCheck.this.targetPosition));
        }

        @Override
        public ISearchOperation getOperation() {
            return BinaryTransitiveClosureCheck.this;
        }
    }
}

