/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.extend;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.IPatternMatcherOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.SingleValueExtendOperationExecutor;
import org.eclipse.viatra.query.runtime.localsearch.operations.util.CallInformation;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryResultProvider;
import org.eclipse.viatra.query.runtime.matchers.tuple.IModifiableTuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.VolatileModifiableMaskedTuple;

public class CountOperation
implements ISearchOperation,
IPatternMatcherOperation {
    private final CallInformation information;
    private final int position;

    public CountOperation(CallInformation information, int position) {
        this.information = information;
        this.position = position;
    }

    @Override
    public ISearchOperation.ISearchOperationExecutor createExecutor() {
        return new Executor(this.position);
    }

    @Override
    public List<Integer> getVariablePositions() {
        return this.information.getVariablePositions();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    @Override
    public String toString(Function<Integer, String> variableMapping) {
        return "extend    -" + variableMapping.apply(this.position) + " = count find " + this.information.toString(variableMapping);
    }

    @Override
    public CallInformation getCallInformation() {
        return this.information;
    }

    private class Executor
    extends SingleValueExtendOperationExecutor<Integer> {
        private final VolatileModifiableMaskedTuple maskedTuple;
        private IQueryResultProvider matcher;

        public Executor(int position) {
            super(position);
            this.maskedTuple = new VolatileModifiableMaskedTuple(CountOperation.this.information.getThinFrameMask());
        }

        @Override
        public Iterator<Integer> getIterator(MatchingFrame frame, ISearchContext context) {
            this.matcher = context.getMatcher(CountOperation.this.information.getReference());
            this.maskedTuple.updateTuple((IModifiableTuple)frame);
            return Collections.singletonList(this.matcher.countMatches(CountOperation.this.information.getParameterMask(), (ITuple)this.maskedTuple)).iterator();
        }

        @Override
        public ISearchOperation getOperation() {
            return CountOperation.this;
        }
    }
}

