/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.planner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.viatra.query.runtime.localsearch.planner.PConstraintCategory;
import org.eclipse.viatra.query.runtime.localsearch.planner.PConstraintInfo;
import org.eclipse.viatra.query.runtime.localsearch.planner.util.OperationCostComparator;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;

public class PlanState {
    private PBody pBody;
    private List<PConstraintInfo> operationsList;
    private Set<PVariable> boundVariables;
    private double cost;
    private List<PConstraintInfo> futureChecks;
    private List<PConstraintInfo> futureExtends;
    private List<PConstraintInfo> presentExtends;

    public PlanState(PBody pBody, List<PConstraintInfo> operationsList, Set<PVariable> boundVariables) {
        this.pBody = pBody;
        this.operationsList = operationsList;
        this.boundVariables = boundVariables;
        this.cost = 0.0;
        double cummulativeProduct = 1.0;
        for (PConstraintInfo constraintInfo : operationsList) {
            double constraintCost = constraintInfo.getCost();
            if (!(constraintCost > 0.0)) continue;
            this.cost += (cummulativeProduct *= constraintCost);
        }
    }

    public void updateOperations(List<PConstraintInfo> allPotentialExtendInfos, List<PConstraintInfo> allPotentialChecks) {
        this.futureChecks = new ArrayList<PConstraintInfo>();
        this.futureExtends = new ArrayList<PConstraintInfo>();
        this.presentExtends = new ArrayList<PConstraintInfo>();
        HashSet<PConstraintInfo> allUsedAppliedConstraints = new HashSet<PConstraintInfo>();
        for (PConstraintInfo pConstraintPlanInfo : this.operationsList) {
            allUsedAppliedConstraints.addAll(pConstraintPlanInfo.getSameWithDifferentBindings());
        }
        HashSet<PConstraintInfo> allUsedAppliedConstraintsArg = allUsedAppliedConstraints;
        Collection allRelevantExtendInfos = allPotentialExtendInfos.stream().filter(input -> !allUsedAppliedConstraintsArg.contains(input) && this.isPossibleExtend((PConstraintInfo)input)).collect(Collectors.toList());
        this.categorizeExtends(allRelevantExtendInfos);
        Collection allRelevantCheckInfos = allPotentialChecks.stream().filter(input -> !allUsedAppliedConstraintsArg.contains(input) && this.isPossibleCheck((PConstraintInfo)input)).collect(Collectors.toList());
        this.categorizeChecks(allRelevantCheckInfos);
        OperationCostComparator infoComparator = new OperationCostComparator();
        Collections.sort(this.futureChecks, infoComparator);
        Collections.sort(this.futureExtends, infoComparator);
        Collections.sort(this.presentExtends, infoComparator);
    }

    private void categorizeChecks(Collection<PConstraintInfo> allRelevantCheckInfos) {
        for (PConstraintInfo checkInfo : allRelevantCheckInfos) {
            PConstraintCategory category = checkInfo.getCategory(this.pBody, this.boundVariables);
            if (category == PConstraintCategory.PRESENT) {
                this.operationsList.add(checkInfo);
                continue;
            }
            if (category != PConstraintCategory.FUTURE) continue;
            this.futureChecks.add(checkInfo);
        }
    }

    private void categorizeExtends(Collection<PConstraintInfo> allRelevantExtendInfos) {
        for (PConstraintInfo constraintInfo : allRelevantExtendInfos) {
            PConstraintCategory category = constraintInfo.getCategory(this.pBody, this.boundVariables);
            if (category == PConstraintCategory.FUTURE) {
                this.futureExtends.add(constraintInfo);
                continue;
            }
            if (category != PConstraintCategory.PRESENT) continue;
            this.presentExtends.add(constraintInfo);
        }
    }

    private boolean isPossibleExtend(PConstraintInfo constraintInfo) {
        PConstraintCategory category = constraintInfo.getCategory(this.getAssociatedPBody(), this.boundVariables);
        if (category == PConstraintCategory.PAST) {
            return false;
        }
        return !constraintInfo.getFreeVariables().isEmpty();
    }

    private boolean isPossibleCheck(PConstraintInfo constraintInfo) {
        PConstraintCategory category = constraintInfo.getCategory(this.getAssociatedPBody(), this.boundVariables);
        if (category == PConstraintCategory.PAST) {
            return false;
        }
        return constraintInfo.getFreeVariables().isEmpty();
    }

    public PBody getAssociatedPBody() {
        return this.pBody;
    }

    public List<PConstraintInfo> getOperations() {
        return this.operationsList;
    }

    public Set<PVariable> getBoundVariables() {
        return this.boundVariables;
    }

    public double getCost() {
        return this.cost;
    }

    public List<PConstraintInfo> getFutureChecks() {
        return this.futureChecks;
    }

    public List<PConstraintInfo> getFutureExtends() {
        return this.futureExtends;
    }

    public List<PConstraintInfo> getPresentExtends() {
        return this.presentExtends;
    }
}

