/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;

public class TextChangeManager {
    private Map fMap = new HashMap(10);
    private final boolean fKeepExecutedTextEdits;

    public TextChangeManager() {
        this(false);
    }

    public TextChangeManager(boolean keepExecutedTextEdits) {
        this.fKeepExecutedTextEdits = keepExecutedTextEdits;
    }

    public void manage(IFile file, TextChange change) {
        this.fMap.put(file, change);
    }

    public TextChange get(IFile file) {
        TextChange result = (TextChange)this.fMap.get(file);
        if (result == null) {
            result = new TextFileChange(file.toString(), file);
            result.setKeepPreviewEdits(this.fKeepExecutedTextEdits);
            result.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
            this.fMap.put(file, result);
        }
        return result;
    }

    public TextChange remove(IFile unit) {
        return (TextChange)this.fMap.remove(unit);
    }

    public TextChange[] getAllChanges() {
        return this.fMap.values().toArray(new TextChange[this.fMap.values().size()]);
    }

    public IFile[] getAllCompilationUnits() {
        return this.fMap.keySet().toArray(new IFile[this.fMap.keySet().size()]);
    }

    public void clear() {
        this.fMap.clear();
    }

    public boolean containsChangesIn(IFile file) {
        return this.fMap.containsKey(file);
    }
}

