/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.edit;

import java.util.List;
import net.sourceforge.nattable.config.CellConfigAttributes;
import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.coordinate.PositionCoordinate;
import net.sourceforge.nattable.data.convert.IDisplayConverter;
import net.sourceforge.nattable.data.validate.IDataValidator;
import net.sourceforge.nattable.edit.ActiveCellEditor;
import net.sourceforge.nattable.edit.EditConfigAttributes;
import net.sourceforge.nattable.edit.command.EditUtils;
import net.sourceforge.nattable.edit.command.UpdateDataCommand;
import net.sourceforge.nattable.edit.editor.ICellEditor;
import net.sourceforge.nattable.edit.event.InlineCellEditEvent;
import net.sourceforge.nattable.edit.gui.MultiCellEditDialog;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.selection.SelectionLayer;
import net.sourceforge.nattable.style.CellStyleProxy;
import net.sourceforge.nattable.tickupdate.ITickUpdateHandler;
import net.sourceforge.nattable.tickupdate.TickUpdateConfigAttributes;
import org.eclipse.swt.widgets.Composite;

public class MultiCellEditController {
    public static boolean editSelectedCells(SelectionLayer selectionLayer, Character initialEditValue, Composite parent, IConfigRegistry configRegistry) {
        LayerCell lastSelectedCell = EditUtils.getLastSelectedCell(selectionLayer);
        if (lastSelectedCell != null) {
            List<String> lastSelectedCellLabelsArray = lastSelectedCell.getConfigLabels().getLabels();
            PositionCoordinate[] selectedCells = selectionLayer.getSelectedCells();
            if (selectedCells.length > 1) {
                ICellEditor lastSelectedCellEditor = configRegistry.getConfigAttribute(EditConfigAttributes.CELL_EDITOR, "EDIT", lastSelectedCellLabelsArray);
                if (EditUtils.isEditorSame(selectionLayer, configRegistry, lastSelectedCellEditor) && EditUtils.allCellsEditable(selectionLayer, configRegistry)) {
                    ICellEditor cellEditor = configRegistry.getConfigAttribute(EditConfigAttributes.CELL_EDITOR, "EDIT", lastSelectedCellLabelsArray);
                    IDisplayConverter dataTypeConverter = configRegistry.getConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, "EDIT", lastSelectedCellLabelsArray);
                    CellStyleProxy cellStyle = new CellStyleProxy(configRegistry, "EDIT", lastSelectedCellLabelsArray);
                    IDataValidator dataValidator = configRegistry.getConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, "EDIT", lastSelectedCellLabelsArray);
                    Object originalCanonicalValue = lastSelectedCell.getDataValue();
                    PositionCoordinate[] positionCoordinateArray = selectedCells;
                    int n = selectedCells.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PositionCoordinate selectedCell = positionCoordinateArray[n2];
                        Object cellValue = selectionLayer.getCellByPosition(selectedCell.columnPosition, selectedCell.rowPosition).getDataValue();
                        if (!cellValue.equals(originalCanonicalValue)) {
                            originalCanonicalValue = null;
                            break;
                        }
                        ++n2;
                    }
                    ITickUpdateHandler tickUpdateHandler = configRegistry.getConfigAttribute(TickUpdateConfigAttributes.UPDATE_HANDLER, "EDIT", lastSelectedCellLabelsArray);
                    boolean allowIncrementDecrement = tickUpdateHandler != null && tickUpdateHandler.isApplicableFor(originalCanonicalValue);
                    MultiCellEditDialog dialog = new MultiCellEditDialog(parent.getShell(), cellEditor, dataTypeConverter, cellStyle, dataValidator, originalCanonicalValue, initialEditValue, allowIncrementDecrement);
                    int returnValue = dialog.open();
                    ActiveCellEditor.close();
                    if (returnValue == 0) {
                        Object editorValue;
                        Object newValue = editorValue = dialog.getEditorValue();
                        if (allowIncrementDecrement) {
                            switch (dialog.getEditType()) {
                                case INCREASE: {
                                    newValue = tickUpdateHandler.getIncrementedValue(originalCanonicalValue);
                                    break;
                                }
                                case DECREASE: {
                                    newValue = tickUpdateHandler.getDecrementedValue(originalCanonicalValue);
                                }
                            }
                        }
                        PositionCoordinate[] positionCoordinateArray2 = selectedCells;
                        int n3 = selectedCells.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            PositionCoordinate selectedCell = positionCoordinateArray2[n4];
                            selectionLayer.doCommand(new UpdateDataCommand(selectionLayer, selectedCell.columnPosition, selectedCell.rowPosition, newValue));
                            ++n4;
                        }
                    }
                }
            } else {
                selectionLayer.fireLayerEvent(new InlineCellEditEvent(selectionLayer, new PositionCoordinate(selectionLayer, lastSelectedCell.getColumnPosition(), lastSelectedCell.getRowPosition()), parent, configRegistry, initialEditValue));
            }
            return true;
        }
        return false;
    }
}

