/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.grid.layer;

import net.sourceforge.nattable.grid.layer.DimensionallyDependentLayer;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.layer.IUniqueIndexLayer;
import net.sourceforge.nattable.layer.LabelStack;
import net.sourceforge.nattable.layer.LayerUtil;
import net.sourceforge.nattable.layer.config.DefaultRowHeaderLayerConfiguration;
import net.sourceforge.nattable.selection.SelectionLayer;

public class RowHeaderLayer
extends DimensionallyDependentLayer {
    private final SelectionLayer selectionLayer;

    public RowHeaderLayer(IUniqueIndexLayer baseLayer, ILayer verticalLayerDependency, SelectionLayer selectionLayer) {
        this(baseLayer, verticalLayerDependency, selectionLayer, true);
    }

    public RowHeaderLayer(IUniqueIndexLayer baseLayer, ILayer verticalLayerDependency, SelectionLayer selectionLayer, boolean useDefaultConfiguration) {
        super(baseLayer, baseLayer, verticalLayerDependency);
        this.selectionLayer = selectionLayer;
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultRowHeaderLayerConfiguration());
        }
    }

    public String getDisplayModeByPosition(int columnPosition, int rowPosition) {
        int selectionLayerRowPosition = LayerUtil.convertRowPosition(this, rowPosition, this.selectionLayer);
        if (this.selectionLayer.isRowPositionSelected(selectionLayerRowPosition)) {
            return "SELECT";
        }
        return super.getDisplayModeByPosition(columnPosition, rowPosition);
    }

    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        LabelStack labelStack = super.getConfigLabelsByPosition(columnPosition, rowPosition);
        int selectionLayerRowPosition = LayerUtil.convertRowPosition(this, rowPosition, this.selectionLayer);
        if (this.selectionLayer.isRowFullySelected(selectionLayerRowPosition)) {
            labelStack.addLabel("ROW_HEADER_FULL");
        }
        return labelStack;
    }
}

