/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.group;

import java.util.List;
import java.util.Properties;
import net.sourceforge.nattable.group.ColumnGroupModel;
import net.sourceforge.nattable.group.ColumnGroupUtils;
import net.sourceforge.nattable.group.command.ColumnGroupsCommandHandler;
import net.sourceforge.nattable.group.config.DefaultColumnGroupHeaderLayerConfiguration;
import net.sourceforge.nattable.layer.AbstractLayerTransform;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.layer.LabelStack;
import net.sourceforge.nattable.layer.SizeConfig;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.layer.event.ColumnStructuralRefreshEvent;
import net.sourceforge.nattable.painter.layer.CellLayerPainter;
import net.sourceforge.nattable.painter.layer.ILayerPainter;
import net.sourceforge.nattable.selection.SelectionLayer;

public class ColumnGroupHeaderLayer
extends AbstractLayerTransform {
    private final SizeConfig rowHeightConfig = new SizeConfig(20);
    private final ColumnGroupModel model;
    private final ILayer columnHeaderLayer;
    private final ILayerPainter layerPainter = new CellLayerPainter();

    public ColumnGroupHeaderLayer(ILayer columnHeaderLayer, SelectionLayer selectionLayer, ColumnGroupModel columnGroupModel) {
        this(columnHeaderLayer, selectionLayer, columnGroupModel, true);
    }

    public ColumnGroupHeaderLayer(ILayer columnHeaderLayer, SelectionLayer selectionLayer, ColumnGroupModel columnGroupModel, boolean useDefaultConfiguration) {
        super(columnHeaderLayer);
        this.columnHeaderLayer = columnHeaderLayer;
        this.model = columnGroupModel;
        this.registerCommandHandler(new ColumnGroupsCommandHandler(this.model, selectionLayer, this));
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultColumnGroupHeaderLayerConfiguration(columnGroupModel));
        }
    }

    public void saveState(String prefix, Properties properties) {
        super.saveState(prefix, properties);
        this.model.saveState(prefix, properties);
    }

    public void loadState(String prefix, Properties properties) {
        super.loadState(prefix, properties);
        this.model.loadState(prefix, properties);
        this.fireLayerEvent(new ColumnStructuralRefreshEvent(this));
    }

    public ILayerPainter getLayerPainter() {
        return this.layerPainter;
    }

    public int getRowCount() {
        return this.columnHeaderLayer.getRowCount() + 1;
    }

    public int getPreferredRowCount() {
        return this.columnHeaderLayer.getPreferredRowCount() + 1;
    }

    public int getRowIndexByPosition(int rowPosition) {
        if (rowPosition == 0) {
            return rowPosition;
        }
        return this.columnHeaderLayer.getRowIndexByPosition(rowPosition - 1);
    }

    public int getHeight() {
        return this.rowHeightConfig.getAggregateSize(1) + this.columnHeaderLayer.getHeight();
    }

    public int getPreferredHeight() {
        return this.rowHeightConfig.getAggregateSize(1) + this.columnHeaderLayer.getPreferredHeight();
    }

    public int getRowHeightByPosition(int rowPosition) {
        if (rowPosition == 0) {
            return this.rowHeightConfig.getSize(rowPosition);
        }
        return this.columnHeaderLayer.getRowHeightByPosition(rowPosition - 1);
    }

    public void setRowHeight(int rowHeight) {
        this.rowHeightConfig.setSize(0, rowHeight);
    }

    public boolean isRowPositionResizable(int rowPosition) {
        if (rowPosition == 0) {
            return this.rowHeightConfig.isPositionResizable(rowPosition);
        }
        return this.columnHeaderLayer.isRowPositionResizable(rowPosition - 1);
    }

    public int getRowPositionByY(int y) {
        int row0Height = this.getRowHeightByPosition(0);
        if (y < row0Height) {
            return 0;
        }
        return 1 + this.columnHeaderLayer.getRowPositionByY(y - row0Height);
    }

    public int getStartYOfRowPosition(int rowPosition) {
        if (rowPosition == 0) {
            return this.rowHeightConfig.getAggregateSize(rowPosition);
        }
        return this.getRowHeightByPosition(0) + this.columnHeaderLayer.getStartYOfRowPosition(rowPosition - 1);
    }

    public LayerCell getCellByPosition(int columnPosition, int rowPosition) {
        int bodyColumnIndex = this.getColumnIndexByPosition(columnPosition);
        if (this.model.isPartOfAGroup(bodyColumnIndex)) {
            if (rowPosition == 0) {
                return new LayerCell(this, this.getStartPositionOfGroup(columnPosition), rowPosition, columnPosition, rowPosition, this.getColumnSpan(columnPosition), 1);
            }
            return new LayerCell(this, columnPosition, rowPosition);
        }
        LayerCell cell = this.columnHeaderLayer.getCellByPosition(columnPosition, 0);
        if (cell != null) {
            cell.updateLayer(this);
            cell.updateRowSpan(2);
        }
        return cell;
    }

    protected int getColumnSpan(int columnPosition) {
        int columnIndex = this.getColumnIndexByPosition(columnPosition);
        if (this.model.isCollapsed(columnIndex)) {
            return 1;
        }
        int startPositionOfGroup = this.getStartPositionOfGroup(columnPosition);
        int sizeOfGroup = this.model.sizeOfGroup(columnIndex);
        int endPositionOfGroup = startPositionOfGroup + sizeOfGroup;
        List<Integer> columnIndexesInGroup = this.model.getColumnIndexesInGroup(columnIndex);
        int i = startPositionOfGroup;
        while (i < endPositionOfGroup) {
            int index = this.getColumnIndexByPosition(i);
            if (!columnIndexesInGroup.contains(index)) {
                --sizeOfGroup;
            }
            ++i;
        }
        return sizeOfGroup;
    }

    private int getStartPositionOfGroup(int columnPosition) {
        int bodyColumnIndex = this.getColumnIndexByPosition(columnPosition);
        int leastPossibleStartPositionOfGroup = columnPosition - this.model.sizeOfGroup(bodyColumnIndex);
        int i = 0;
        i = leastPossibleStartPositionOfGroup;
        while (i < columnPosition) {
            if (ColumnGroupUtils.isInTheSameGroup(this.getColumnIndexByPosition(i), bodyColumnIndex, this.model)) break;
            ++i;
        }
        return i;
    }

    public String getDisplayModeByPosition(int columnPosition, int rowPosition) {
        int columnIndex = this.getColumnIndexByPosition(columnPosition);
        if (rowPosition == 0 && this.model.isPartOfAGroup(columnIndex)) {
            return "NORMAL";
        }
        return this.columnHeaderLayer.getDisplayModeByPosition(columnPosition, rowPosition);
    }

    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        int columnIndex = this.getColumnIndexByPosition(columnPosition);
        if (rowPosition == 0 && this.model.isPartOfAGroup(columnIndex)) {
            return new LabelStack("COLUMN_GROUP_HEADER");
        }
        return this.columnHeaderLayer.getConfigLabelsByPosition(columnPosition, rowPosition);
    }

    public Object getDataValueByPosition(int columnPosition, int rowPosition) {
        int columnIndex = this.getColumnIndexByPosition(columnPosition);
        if (rowPosition == 0 && this.model.isPartOfAGroup(columnIndex)) {
            return this.model.getColumnGroupNameForIndex(columnIndex);
        }
        return this.columnHeaderLayer.getDataValueByPosition(columnPosition, 0);
    }

    public LabelStack getRegionLabelsByXY(int x, int y) {
        int columnIndex = this.getColumnIndexByPosition(this.getColumnPositionByX(x));
        if (this.model.isPartOfAGroup(columnIndex) && y < this.getRowHeightByPosition(0)) {
            return new LabelStack("COLUMN_GROUP_HEADER");
        }
        return this.columnHeaderLayer.getRegionLabelsByXY(x, y - this.getRowHeightByPosition(0));
    }

    public void addColumnsIndexesToGroup(String colGroupName, int ... colIndexes) {
        this.model.addColumnsIndexesToGroup(colGroupName, colIndexes);
    }

    public void collapseColumnGroupByIndex(int columnIndex) {
        this.model.collapse(columnIndex);
    }

    public void clearAllGroups() {
        this.model.clear();
    }

    public void setGroupUnbreakable(int columnIndex) {
        this.model.setGroupUnBreakable(columnIndex);
    }

    public void setGroupAsCollapsed(int i) {
        this.model.collapse(i);
    }
}

