/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.selection;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.nattable.data.IRowDataProvider;
import net.sourceforge.nattable.layer.event.ILayerEventHandler;
import net.sourceforge.nattable.layer.event.IVisualChangeEvent;
import net.sourceforge.nattable.layer.event.RowStructuralChangeEvent;
import net.sourceforge.nattable.layer.event.RowStructuralRefreshEvent;
import net.sourceforge.nattable.selection.RowSelectionProvider;
import net.sourceforge.nattable.selection.SelectionLayer;
import net.sourceforge.nattable.sort.event.SortColumnEvent;
import net.sourceforge.nattable.util.ObjectUtils;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowSelectionPreserver<T>
implements ILayerEventHandler<IVisualChangeEvent> {
    private final SelectionLayer selectionLayer;
    private final RowSelectionProvider<T> selectionProvider;
    private final IRowDataProvider<T> rowDataProvider;
    private List<T> selectedRowObjects = new ArrayList<T>();

    public RowSelectionPreserver(SelectionLayer selectionLayer, IRowDataProvider<T> rowDataProvider) {
        this.selectionLayer = selectionLayer;
        this.rowDataProvider = rowDataProvider;
        this.selectionProvider = new RowSelectionProvider<T>(selectionLayer, rowDataProvider, true);
        this.selectionProvider.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RowSelectionPreserver.this.selectedRowObjects = ((StructuredSelection)event.getSelection()).toList();
            }
        });
    }

    private List<T> getValidSelections() {
        ArrayList<T> newSelection = new ArrayList<T>();
        for (T rowObj : this.selectedRowObjects) {
            int index = this.rowDataProvider.indexOfRowObject(rowObj);
            if (index == -1) continue;
            newSelection.add(rowObj);
        }
        return newSelection;
    }

    @Override
    public void handleLayerEvent(IVisualChangeEvent event) {
        if (ObjectUtils.isEmpty(this.selectedRowObjects)) {
            return;
        }
        if (event instanceof RowStructuralRefreshEvent || event instanceof RowStructuralChangeEvent || event instanceof SortColumnEvent) {
            this.selectionLayer.clear();
            this.selectionProvider.setSelection((ISelection)new StructuredSelection(this.getValidSelections()));
        }
    }

    @Override
    public Class<IVisualChangeEvent> getLayerEventClass() {
        return IVisualChangeEvent.class;
    }
}

