/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.sort.painter;

import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.painter.cell.CellPainterWrapper;
import net.sourceforge.nattable.painter.cell.ICellPainter;
import net.sourceforge.nattable.painter.cell.ImagePainter;
import net.sourceforge.nattable.painter.cell.TextPainter;
import net.sourceforge.nattable.painter.cell.decorator.CellPainterDecorator;
import net.sourceforge.nattable.ui.util.CellEdgeEnum;
import net.sourceforge.nattable.util.GUIHelper;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.graphics.Image;

public class SortableHeaderTextPainter
extends CellPainterWrapper {
    public SortableHeaderTextPainter() {
        this.setWrappedPainter(new CellPainterDecorator(new TextPainter(), CellEdgeEnum.RIGHT, new SortIconPainter(true)));
    }

    public SortableHeaderTextPainter(ICellPainter integriorPainter, boolean paintBg) {
        this.setWrappedPainter(new CellPainterDecorator(integriorPainter, CellEdgeEnum.RIGHT, new SortIconPainter(paintBg)));
    }

    protected static class SortIconPainter
    extends ImagePainter {
        public SortIconPainter(boolean paintBg) {
            super(null, paintBg);
        }

        protected Image getImage(LayerCell cell, IConfigRegistry configRegistry) {
            Image icon = null;
            if (this.isSortedAscending(cell)) {
                icon = this.selectUpImage(this.getSortSequence(cell));
            } else if (this.isSortedDescending(cell)) {
                icon = this.selectDownImage(this.getSortSequence(cell));
            }
            return icon;
        }

        private boolean isSortedAscending(LayerCell cell) {
            return cell.getConfigLabels().hasLabel("SORT_UP");
        }

        private boolean isSortedDescending(LayerCell cell) {
            return cell.getConfigLabels().hasLabel("SORT_DOWN");
        }

        private int getSortSequence(LayerCell cell) {
            int sortSeq = 0;
            for (String configLabel : cell.getConfigLabels().getLabels()) {
                if (!configLabel.startsWith("SORT_SEQ_")) continue;
                String[] tokens = StringUtils.split((String)configLabel, (String)"_");
                sortSeq = Integer.valueOf(tokens[tokens.length - 1]);
            }
            return sortSeq;
        }

        private Image selectUpImage(int sortSequence) {
            switch (sortSequence) {
                case 0: {
                    return GUIHelper.getImage("up_0");
                }
                case 1: {
                    return GUIHelper.getImage("up_1");
                }
                case 2: {
                    return GUIHelper.getImage("up_2");
                }
            }
            return GUIHelper.getImage("up_2");
        }

        private Image selectDownImage(int sortSequence) {
            switch (sortSequence) {
                case 0: {
                    return GUIHelper.getImage("down_0");
                }
                case 1: {
                    return GUIHelper.getImage("down_1");
                }
                case 2: {
                    return GUIHelper.getImage("down_2");
                }
            }
            return GUIHelper.getImage("down_2");
        }
    }
}

