/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.viewport.command;

import net.sourceforge.nattable.command.AbstractLayerCommandHandler;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.layer.IUniqueIndexLayer;
import net.sourceforge.nattable.selection.command.SelectRowsCommand;
import net.sourceforge.nattable.viewport.ViewportLayer;
import net.sourceforge.nattable.viewport.command.ViewportSelectRowCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewportSelectRowCommandHandler
extends AbstractLayerCommandHandler<ViewportSelectRowCommand> {
    private final ViewportLayer viewportLayer;

    public ViewportSelectRowCommandHandler(ViewportLayer viewportLayer) {
        this.viewportLayer = viewportLayer;
    }

    @Override
    public Class<ViewportSelectRowCommand> getCommandClass() {
        return ViewportSelectRowCommand.class;
    }

    @Override
    protected boolean doCommand(ViewportSelectRowCommand command) {
        IUniqueIndexLayer scrollableLayer = this.viewportLayer.getScrollableLayer();
        int scrollableColumnPosition = this.viewportLayer.getOriginColumnPosition();
        int scrollableRowPosition = this.viewportLayer.localToUnderlyingRowPosition(command.getRowPosition());
        scrollableLayer.doCommand(new SelectRowsCommand((ILayer)scrollableLayer, scrollableColumnPosition, new int[]{scrollableRowPosition}, command.isWithShiftMask(), command.isWithControlMask()));
        return true;
    }
}

