/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobGroup;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.JobFamilies;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.lib.BranchConfig;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.osgi.util.NLS;

public class PullOperation
implements IEGitOperation {
    private final Repository[] repositories;
    private Map<Repository, PullReferenceConfig> configs;
    private final Map<Repository, PullResult> results;
    private final int timeout;
    private CredentialsProvider credentialsProvider;

    public PullOperation(Set<Repository> repositories, int timeout) {
        this.timeout = timeout;
        this.repositories = repositories.toArray(new Repository[repositories.size()]);
        this.configs = Collections.emptyMap();
        this.results = new LinkedHashMap<Repository, PullResult>();
    }

    public PullOperation(@NonNull Map<Repository, PullReferenceConfig> repositories, int timeout) {
        this(repositories.keySet(), timeout);
        this.configs = repositories;
    }

    @Override
    public void execute(IProgressMonitor m) throws CoreException {
        if (!this.results.isEmpty()) {
            throw new CoreException((IStatus)new Status(4, Activator.getPluginId(), CoreText.OperationAlreadyExecuted));
        }
        int workers = this.repositories.length;
        String taskName = NLS.bind((String)CoreText.PullOperation_TaskName, (Object)workers);
        int maxThreads = this.getMaxPullThreadsCount();
        PullJobGroup jobGroup = new PullJobGroup(taskName, maxThreads, workers);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)m, (int)workers);
        Repository[] repositoryArray = this.repositories;
        int n = this.repositories.length;
        int n2 = 0;
        while (n2 < n) {
            Repository repository = repositoryArray[n2];
            PullJob pullJob = new PullJob(repository, this.configs.get(repository));
            pullJob.setJobGroup(jobGroup);
            pullJob.schedule();
            ++n2;
        }
        long noTimeout = 0L;
        try {
            jobGroup.join(noTimeout, (IProgressMonitor)progress);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (OperationCanceledException e) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
    }

    private int getMaxPullThreadsCount() {
        String key = "core_max_pull_threads_count";
        int defaultValue = 1;
        int value = Platform.getPreferencesService().getInt(Activator.getPluginId(), key, defaultValue, null);
        return Math.max(defaultValue, value);
    }

    static String getPullTaskName(Repository repo, PullReferenceConfig rc) {
        String remoteUri;
        String branchName;
        StoredConfig config = repo.getConfig();
        if (rc != null) {
            String remoteUri2 = config.getString("remote", rc.remote, "url");
            return "Pulling " + rc.remote + " from " + remoteUri2;
        }
        try {
            String fullBranch = repo.getFullBranch();
            branchName = fullBranch != null ? fullBranch.substring("refs/heads/".length()) : "";
        }
        catch (IOException e) {
            return "Pulling from " + repo.toString();
        }
        String remote = config.getString("branch", branchName, "remote");
        if (remote == null) {
            remote = "origin";
        }
        if ((remoteUri = config.getString("remote", remote, "url")) != null) {
            return "Pulling " + remote + " from " + remoteUri;
        }
        return "Pulling from " + repo.getDirectory();
    }

    boolean refreshNeeded(PullResult pullResult) {
        if (pullResult == null) {
            return true;
        }
        RebaseResult rebaseResult = pullResult.getRebaseResult();
        if (rebaseResult != null && rebaseResult.getStatus() == RebaseResult.Status.UP_TO_DATE) {
            return false;
        }
        MergeResult mergeResult = pullResult.getMergeResult();
        return mergeResult == null || mergeResult.getMergeStatus() != MergeResult.MergeStatus.ALREADY_UP_TO_DATE;
    }

    public Map<Repository, PullResult> getResults() {
        return this.results;
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return null;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    static /* synthetic */ int access$0(PullOperation pullOperation) {
        return pullOperation.timeout;
    }

    static /* synthetic */ CredentialsProvider access$1(PullOperation pullOperation) {
        return pullOperation.credentialsProvider;
    }

    static /* synthetic */ Map access$2(PullOperation pullOperation) {
        return pullOperation.results;
    }

    private final class PullJob
    extends Job {
        private final Repository repository;
        private final PullReferenceConfig config;

        PullJob(Repository repository, PullReferenceConfig config) {
            super(PullOperation.getPullTaskName(repository, config));
            this.repository = repository;
            this.config = config;
            this.setRule(RuleUtil.getRule(repository));
        }

        /*
         * Exception decompiling
         */
        public IStatus run(IProgressMonitor mymonitor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public boolean belongsTo(Object family) {
            return JobFamilies.PULL.equals(family);
        }
    }

    private static class PullJobGroup
    extends JobGroup {
        public PullJobGroup(String name, int maxThreads, int initialJobCount) {
            super(name, maxThreads, initialJobCount);
        }

        protected boolean shouldCancel(IStatus lastCompletedJobResult, int numberOfFailedJobs, int numberOfCancelledJobs) {
            return false;
        }
    }

    public static class PullReferenceConfig {
        private String remote;
        private String reference;
        private BranchConfig.BranchRebaseMode upstreamConfig;

        public PullReferenceConfig(@Nullable String remote, @Nullable String reference, @Nullable BranchConfig.BranchRebaseMode upstreamConfig) {
            this.remote = remote;
            this.reference = reference;
            this.upstreamConfig = upstreamConfig;
        }

        @Nullable
        public String getRemote() {
            return this.remote;
        }

        @Nullable
        public String getReference() {
            return this.reference;
        }

        @Nullable
        public BranchConfig.BranchRebaseMode getUpstreamConfig() {
            return this.upstreamConfig;
        }
    }
}

