/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.emf.cdo.common.id.CDOIDExternal;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBDatabase;
import org.eclipse.net4j.db.IDBPreparedStatement;
import org.eclipse.net4j.db.IDBResultSet;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class ExternalReferenceManager
extends Lifecycle {
    private static final String EXTERNAL_REFS = "cdo_external_refs";
    private static final String EXTERNAL_REFS_ID = "ID";
    private static final String EXTERNAL_REFS_URI = "URI";
    private static final String EXTERNAL_REFS_COMMITTIME = "COMMITTIME";
    private static final int NULL = 0;
    private IDBTable table;
    private final IIDHandler idHandler;
    private AtomicLong lastMappedID = new AtomicLong(0L);
    @ReflectUtil.ExcludeFromDump
    private transient String sqlSelectByLongID;
    @ReflectUtil.ExcludeFromDump
    private transient String sqlSelectByURI;
    @ReflectUtil.ExcludeFromDump
    private transient String sqlInsert;

    public ExternalReferenceManager(IIDHandler idHandler) {
        this.idHandler = idHandler;
    }

    public IIDHandler getIDHandler() {
        return this.idHandler;
    }

    public long mapExternalReference(CDOIDExternal id, long commitTime) {
        IDBStoreAccessor accessor = ExternalReferenceManager.getAccessor();
        return this.mapURI(accessor, id.getURI(), commitTime);
    }

    public CDOIDExternal unmapExternalReference(long mappedId) {
        IDBStoreAccessor accessor = ExternalReferenceManager.getAccessor();
        return CDOIDUtil.createExternal((String)this.unmapURI(accessor, mappedId));
    }

    public long mapURI(IDBStoreAccessor accessor, String uri, long commitTime) {
        long result = this.lookupByURI(accessor, uri);
        if (result < 0L) {
            return result;
        }
        return this.insertNew(accessor, uri, commitTime);
    }

    public String unmapURI(IDBStoreAccessor accessor, long mappedId) {
        String string;
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlSelectByLongID, IDBPreparedStatement.ReuseProbability.HIGH);
        IDBResultSet resultSet = null;
        try {
            stmt.setLong(1, mappedId);
            resultSet = stmt.executeQuery();
            if (!resultSet.next()) {
                OM.LOG.error("External ID " + mappedId + " not found. Database inconsistent!");
                throw new IllegalStateException("External ID " + mappedId + " not found. Database inconsistent!");
            }
            string = resultSet.getString(1);
        }
        catch (SQLException e) {
            try {
                throw new DBException((Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                DBUtil.close((Statement)stmt);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
        return string;
    }

    public long lookupByURI(IDBStoreAccessor accessor, String uri) {
        IDBResultSet resultSet;
        IDBPreparedStatement stmt;
        block4: {
            long l;
            stmt = accessor.getDBConnection().prepareStatement(this.sqlSelectByURI, IDBPreparedStatement.ReuseProbability.HIGH);
            resultSet = null;
            try {
                stmt.setString(1, uri);
                resultSet = stmt.executeQuery();
                if (!resultSet.next()) break block4;
                l = resultSet.getLong(1);
            }
            catch (SQLException e) {
                try {
                    throw new DBException((Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtil.close(resultSet);
                    DBUtil.close((Statement)stmt);
                    throw throwable;
                }
            }
            DBUtil.close((ResultSet)resultSet);
            DBUtil.close((Statement)stmt);
            return l;
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
        return 0L;
    }

    public void rawExport(Connection connection, CDODataOutput out, long fromCommitTime, long toCommitTime) throws IOException {
        String where = " WHERE COMMITTIME BETWEEN " + fromCommitTime + " AND " + toCommitTime;
        DBUtil.serializeTable((ExtendedDataOutput)out, (Connection)connection, (IDBTable)this.table, null, (String)where);
    }

    public void rawImport(Connection connection, CDODataInput in, long fromCommitTime, long toCommitTime, OMMonitor monitor) throws IOException {
        DBUtil.deserializeTable((ExtendedDataInput)in, (Connection)connection, (IDBTable)this.table, (OMMonitor)monitor);
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        final IDBStore store = this.idHandler.getStore();
        IDBDatabase database = store.getDatabase();
        this.table = database.getSchema().getTable(EXTERNAL_REFS);
        if (this.table == null) {
            database.updateSchema(new IDBDatabase.RunnableWithSchema(){

                public void run(IDBSchema schema) {
                    ExternalReferenceManager.this.table = schema.addTable(ExternalReferenceManager.EXTERNAL_REFS);
                    ExternalReferenceManager.this.table.addField(ExternalReferenceManager.EXTERNAL_REFS_ID, ExternalReferenceManager.this.idHandler.getDBType(), store.getIDColumnLength(), true);
                    ExternalReferenceManager.this.table.addField(ExternalReferenceManager.EXTERNAL_REFS_URI, DBType.VARCHAR, 1024);
                    ExternalReferenceManager.this.table.addField(ExternalReferenceManager.EXTERNAL_REFS_COMMITTIME, DBType.BIGINT);
                    ExternalReferenceManager.this.table.addIndex(IDBIndex.Type.PRIMARY_KEY, new String[]{ExternalReferenceManager.EXTERNAL_REFS_ID});
                    ExternalReferenceManager.this.table.addIndex(IDBIndex.Type.NON_UNIQUE, new String[]{ExternalReferenceManager.EXTERNAL_REFS_URI});
                }
            });
        } else {
            String sql = "SELECT MIN(ID) FROM " + this.table;
            IDBStoreAccessor writer = store.getWriter(null);
            IDBPreparedStatement stmt = writer.getDBConnection().prepareStatement(sql, IDBPreparedStatement.ReuseProbability.LOW);
            IDBResultSet resultSet = null;
            try {
                try {
                    resultSet = stmt.executeQuery();
                    if (resultSet.next()) {
                        this.lastMappedID.set(resultSet.getLong(1));
                    }
                }
                catch (SQLException ex) {
                    writer.getDBConnection().rollback();
                    throw new DBException((Throwable)ex);
                }
            }
            finally {
                DBUtil.close((ResultSet)resultSet);
                DBUtil.close((Statement)stmt);
                writer.release();
            }
        }
        this.sqlInsert = "INSERT INTO " + this.table + "(" + EXTERNAL_REFS_ID + "," + EXTERNAL_REFS_URI + "," + EXTERNAL_REFS_COMMITTIME + ") VALUES (?, ?, ?)";
        this.sqlSelectByURI = "SELECT ID FROM " + this.table + " WHERE " + EXTERNAL_REFS_URI + "=?";
        this.sqlSelectByLongID = "SELECT URI FROM " + this.table + " WHERE " + EXTERNAL_REFS_ID + "=?";
    }

    private long insertNew(IDBStoreAccessor accessor, String uri, long commitTime) {
        long newMappedID = this.lastMappedID.decrementAndGet();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlInsert, IDBPreparedStatement.ReuseProbability.MEDIUM);
        try {
            stmt.setLong(1, newMappedID);
            stmt.setString(2, uri);
            stmt.setLong(3, commitTime);
            DBUtil.update((PreparedStatement)stmt, (boolean)true);
            long l = newMappedID;
            return l;
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e);
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    private static IDBStoreAccessor getAccessor() {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        if (accessor == null) {
            throw new IllegalStateException("Can only be called from within a valid IDBStoreAccessor context");
        }
        return (IDBStoreAccessor)accessor;
    }
}

