/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.embedded;

import java.util.List;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchPointRange;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.server.internal.embedded.ServerSession;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.common.revision.RevisionInfo;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.ecore.EClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServerRevisionLoader
implements InternalCDORevisionManager.RevisionLoader2 {
    private final InternalCDORevisionManager.RevisionLoader2 delegate;

    public ServerRevisionLoader(InternalCDORevisionManager.RevisionLoader2 delegate) {
        this.delegate = delegate;
    }

    public InternalCDORevisionManager.RevisionLoader2 getDelegate() {
        return this.delegate;
    }

    public List<RevisionInfo> loadRevisions(List<RevisionInfo> infos, CDOBranchPoint branchPoint, int referenceChunk, int prefetchDepth) {
        InternalSession serverSession = ServerSession.get();
        if (serverSession != null) {
            try {
                StoreThreadLocal.setSession((InternalSession)serverSession);
                List list = this.delegate.loadRevisions(infos, branchPoint, referenceChunk, prefetchDepth);
                return list;
            }
            finally {
                StoreThreadLocal.release();
            }
        }
        return this.delegate.loadRevisions(infos, branchPoint, referenceChunk, prefetchDepth);
    }

    public InternalCDORevision loadRevisionByVersion(CDOID id, CDOBranchVersion branchVersion, int referenceChunk) {
        InternalSession serverSession = ServerSession.get();
        if (serverSession != null) {
            try {
                StoreThreadLocal.setSession((InternalSession)serverSession);
                InternalCDORevision internalCDORevision = this.delegate.loadRevisionByVersion(id, branchVersion, referenceChunk);
                return internalCDORevision;
            }
            finally {
                StoreThreadLocal.release();
            }
        }
        return this.delegate.loadRevisionByVersion(id, branchVersion, referenceChunk);
    }

    public void handleRevisions(EClass eClass, CDOBranch branch, boolean exactBranch, long timeStamp, boolean exactTime, CDORevisionHandler handler) {
        InternalSession serverSession = ServerSession.get();
        if (serverSession != null) {
            try {
                StoreThreadLocal.setSession((InternalSession)serverSession);
                this.delegate.handleRevisions(eClass, branch, exactBranch, timeStamp, exactTime, handler);
            }
            finally {
                StoreThreadLocal.release();
            }
        } else {
            this.delegate.handleRevisions(eClass, branch, exactBranch, timeStamp, exactTime, handler);
        }
    }

    public CDOBranchPointRange loadObjectLifetime(CDOID id, CDOBranchPoint branchPoint) {
        InternalSession serverSession = ServerSession.get();
        if (serverSession != null) {
            try {
                StoreThreadLocal.setSession((InternalSession)serverSession);
                CDOBranchPointRange cDOBranchPointRange = this.delegate.loadObjectLifetime(id, branchPoint);
                return cDOBranchPointRange;
            }
            finally {
                StoreThreadLocal.release();
            }
        }
        return this.delegate.loadObjectLifetime(id, branchPoint);
    }
}

