/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.workbench.internal.editor;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.IFacetManagerProvider;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidget;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetInternal;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetProvider;
import org.eclipse.emf.facet.widgets.table.ui.workbench.internal.editor.NatTableEditorFactory;
import org.eclipse.emf.facet.widgets.table.ui.workbench.internal.editor.TableEditor;
import org.eclipse.emf.facet.widgets.table.ui.workbench.internal.editor.TableEditorInput;
import org.eclipse.emf.facet.widgets.table.ui.workbench.internal.exported.IPropertyChanger;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class DelegatedTableEditor
extends EditorPart
implements ISelectionProvider,
IEditingDomainProvider,
IPropertyChanger {
    private TableEditorInput tableEditorInput;
    private ITableWidget tableWidget;
    private EditingDomain editingDomain;
    private final List<IPropertyListener> propertyListeners = new ArrayList<IPropertyListener>();
    private final CommandStackListener commandListener = new CommandStackListener(){

        public void commandStackChanged(EventObject event) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    DelegatedTableEditor.this.firePropertyChange(257);
                }
            });
        }
    };

    protected void firePropertyChange(int propertyId) {
        super.firePropertyChange(propertyId);
        for (IPropertyListener listener : this.propertyListeners) {
            listener.propertyChanged((Object)this, propertyId);
        }
    }

    public Object getAdapter(Class adapter) {
        Object result = null;
        if (adapter.isInstance(this)) {
            result = this;
        } else if (adapter == ITableWidgetProvider.class) {
            result = new ITableWidgetProvider(){

                public ITableWidget getTableWidget() {
                    return DelegatedTableEditor.this.getTableWidget();
                }
            };
        } else if (adapter == IFacetManagerProvider.class) {
            ITableWidgetInternal intenalTable = (ITableWidgetInternal)this.tableWidget;
            final IFacetManager facetMgr = intenalTable.getFacetContext();
            result = new IFacetManagerProvider(){

                public IFacetManager getFacetManager() {
                    return facetMgr;
                }
            };
        }
        return result;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (input instanceof TableEditorInput) {
            this.tableEditorInput = (TableEditorInput)input;
            this.editingDomain = this.tableEditorInput.getEditingDomain();
            this.initializeEditingDomain();
            this.setSite((IWorkbenchPartSite)site);
            this.setInput(this.tableEditorInput);
            this.setPartName(this.tableEditorInput.getName());
        } else if (input instanceof FileEditorInput) {
            this.initializeEditingDomain();
            FileEditorInput fileEditorInput = (FileEditorInput)input;
            URI uri = URI.createPlatformResourceURI((String)fileEditorInput.getFile().getFullPath().toString(), (boolean)true);
            if (uri != null) {
                Resource resource = null;
                if (this.getEditingDomain() == null) {
                    ResourceSetImpl rSet = new ResourceSetImpl();
                    resource = rSet.createResource(uri);
                } else {
                    resource = this.getEditingDomain().loadResource(uri.toString());
                }
                Table tableInstance = null;
                for (EObject eObject : resource.getContents()) {
                    if (!(eObject instanceof Table)) continue;
                    tableInstance = (Table)eObject;
                    break;
                }
                this.tableEditorInput = new TableEditorInput(tableInstance, this.getEditingDomain());
                this.setSite((IWorkbenchPartSite)site);
                this.setInput(this.tableEditorInput);
                this.setPartName(fileEditorInput.getName());
            }
        } else {
            throw new PartInitException("Input should be of type TableEditorInput or a .table file");
        }
    }

    public void createPartControl(Composite parent) {
        MenuManager menuMgr = new MenuManager("#PopUp", TableEditor.getEditorId());
        menuMgr.setRemoveAllWhenShown(true);
        Composite editorComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 2;
        editorComposite.setLayout((Layout)gridLayout);
        Label label = new Label(editorComposite, 0);
        label.setText(this.tableEditorInput.getDescription());
        this.tableWidget = ITableWidgetFactory.INSTANCE.createTableWidget(editorComposite, (IEditingDomainProvider)this, this.tableEditorInput.getTableInstance(), menuMgr);
        GridData tableGridData = new GridData();
        tableGridData.grabExcessHorizontalSpace = true;
        tableGridData.grabExcessVerticalSpace = true;
        tableGridData.horizontalAlignment = 4;
        tableGridData.verticalAlignment = 4;
        this.tableWidget.getComposite().setLayoutData((Object)tableGridData);
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableWidget);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.tableWidget);
    }

    public void setFocus() {
        this.tableWidget.getComposite().setFocus();
    }

    public boolean isDirty() {
        return ((ITableWidgetInternal)this.tableWidget).usesTmpResource() || ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSave(IProgressMonitor monitor) {
        this.tableWidget.save();
        this.firePropertyChange(257);
    }

    public void doSaveAs() {
        this.tableWidget.saveAs();
        this.firePropertyChange(257);
    }

    protected NatTableEditorFactory getFactory() {
        return NatTableEditorFactory.getInstance();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.tableWidget.addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return this.tableWidget.getSelection();
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.tableWidget.removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.tableWidget.setSelection(selection);
    }

    protected void initializeEditingDomain() {
        if (this.editingDomain == null) {
            ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            BasicCommandStack commandStack = new BasicCommandStack();
            this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, new HashMap());
        }
        this.editingDomain.getCommandStack().removeCommandStackListener(this.commandListener);
        this.editingDomain.getCommandStack().addCommandStackListener(this.commandListener);
    }

    public IWorkbenchPart getPart() {
        return this;
    }

    ITableWidget getTableWidget() {
        return this.tableWidget;
    }

    public void addPropertyChangeListener(IPropertyListener listener) {
        if (!this.propertyListeners.contains(listener)) {
            this.propertyListeners.add(listener);
        }
    }

    public void removePropertyChangeListener(IPropertyListener listener) {
        this.propertyListeners.remove(listener);
    }
}

