/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal.widget.column;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.emf.facet.custom.core.exception.CustomizationException;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.emf.facet.custom.ui.IContentPropertiesHandler;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetElement;
import org.eclipse.emf.facet.util.core.DebugUtils;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.FeatureColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.SourceColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.TableWidgetInternalUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.dialog.IColumnsToHideDialog;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.exception.TableWidgetRuntimeException;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.column.ColumnsCommandFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.column.ColumnsToHideDialog;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.command.BasicCommandFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.facetcustom.CustomizationUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.preferences.PreferenceConstants;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.utils.EditingDomainUtils;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnsHideService {
    private final Table table;
    private final ColumnsCommandFactory columnsCmdFactory;
    private final EditingDomain editingDomain;

    public ColumnsHideService(Table table, BasicCommandFactory basicCmdFactory) {
        this.table = table;
        this.columnsCmdFactory = new ColumnsCommandFactory(table, basicCmdFactory);
        this.editingDomain = basicCmdFactory.getEditingDomain();
    }

    public IColumnsToHideDialog openColumnsToHideDialog() {
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Column) {
                    Column column = (Column)element;
                    return TableWidgetInternalUtils.getColumnName(column);
                }
                return null;
            }
        };
        boolean localCustoMustTop = PreferenceConstants.isMustPutOnTheTopTheLocalCustom();
        boolean askTopLocalCusto = PreferenceConstants.isAskToPutOnTheTopTheLocalCustomization();
        final ColumnsToHideDialog dialog = new ColumnsToHideDialog(Display.getDefault().getActiveShell(), this.table.getColumns(), (ILabelProvider)labelProvider, CustomizationUtils.isOneOfTheLocalCustomizationsNotOnTheTop(this.table) && askTopLocalCusto, localCustoMustTop){

            @Override
            protected void okPressed() {
                super.okPressed();
                if (this.getResult() != null) {
                    boolean putOnTop = this.isPutOnTheTop() && CustomizationUtils.isOneOfTheLocalCustomizationsNotOnTheTop(ColumnsHideService.this.getTable());
                    ColumnsHideService.this.showHideColumns(this.getSelectedColumns(), putOnTop);
                    ColumnsHideService.setMustAskThUserToPutOnTheTopTheLocalCustomizationNextTime(this.isMustAskTheUserNextTime(), this.isPutOnTheTop());
                }
            }

            @Override
            public List<Column> getVisibleColumns(boolean putOnTheTop) {
                return ColumnsHideService.this.getVisibleColumns(putOnTheTop);
            }
        };
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
        return dialog;
    }

    public void showHideColumns(List<Column> columnToShow, boolean putOnTheTop) {
        List<Column> visibleColumns = this.getVisibleColumns(putOnTheTop);
        Command cmd = this.columnsCmdFactory.createShowHideColumnCommand(columnToShow, visibleColumns, putOnTheTop);
        EditingDomainUtils.executeCommand(cmd, this.editingDomain);
    }

    public List<Column> getVisibleColumns(boolean setAtTheTop) {
        ArrayList<Column> notHiddenColumns = new ArrayList();
        try {
            notHiddenColumns = this.getVisibleColumnsUsingTheLocalCustomizations(setAtTheTop);
        }
        catch (Exception e) {
            throw new TableWidgetRuntimeException(e);
        }
        return notHiddenColumns;
    }

    public List<Column> getVisibleColumnsUsingTheLocalCustomizations(boolean setToTheTop) throws CustomizationException {
        ICustomizationManager customManager = CustomizationUtils.getCustomManager((EObject)this.table);
        if (setToTheTop) {
            for (Customization customization : this.table.getCustomizations()) {
                customManager.getManagedCustomizations().add(0, customization);
            }
        } else {
            for (Customization customization : this.table.getLocalCustomizations()) {
                customManager.getManagedCustomizations().add(0, customization);
            }
        }
        ArrayList<Column> notHiddenColumns = new ArrayList<Column>();
        IContentPropertiesHandler contentPropH = CustomizationUtils.getContentPropertiesHandler(this.table);
        for (Column c : this.table.getColumns()) {
            boolean isVisible = true;
            if (c instanceof FeatureColumn) {
                FeatureColumn featureColumn = (FeatureColumn)c;
                ETypedElement typedElement = featureColumn.getFeature();
                isVisible = (Boolean)customManager.getCustomValueOf((EObject)typedElement, contentPropH.getIsVisible(), Boolean.class);
            } else if (c instanceof SourceColumn) {
                SourceColumn sourceColumn = (SourceColumn)c;
                isVisible = !sourceColumn.isIsHidden();
            } else {
                throw new IllegalStateException("Unknown column type");
            }
            if (!isVisible) continue;
            notHiddenColumns.add(c);
        }
        return notHiddenColumns;
    }

    protected static void setMustAskThUserToPutOnTheTopTheLocalCustomizationNextTime(boolean askUserNextTime, boolean putOnTheTop) {
        PreferenceConstants.setAskToPutOnTheTopTheLocalCustomization(askUserNextTime);
        if (!askUserNextTime) {
            PreferenceConstants.setMustPutOnTheTopTheLocalCustom(putOnTheTop);
        }
    }

    protected Table getTable() {
        return this.table;
    }

    public void debugNbColumns() {
        EList columns = this.table.getColumns();
        int nbVisibleColumns = this.getVisibleColumns(false).size();
        int nbColumns = columns.size();
        int nbNonFacetColumns = 0;
        for (Column column : columns) {
            if (column instanceof FeatureColumn) {
                FeatureColumn featureColumn = (FeatureColumn)column;
                if (featureColumn.getFeature() instanceof FacetElement) continue;
                ++nbNonFacetColumns;
                continue;
            }
            ++nbNonFacetColumns;
        }
        DebugUtils.debug((String)"nbColumns=", (Object[])new Object[]{String.valueOf(nbColumns)});
        DebugUtils.debug((String)"nbVisibleColumnsUsingTheLayer=", (Object[])new Object[]{String.valueOf(nbVisibleColumns)});
        DebugUtils.debug((String)"nbNonFacetColumns=", (Object[])new Object[]{String.valueOf(nbNonFacetColumns)});
    }
}

