/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.logging.aeri.core;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>User Settings</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.IUserSettings#getReporterId <em>Reporter Id</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.IUserSettings#getReporterName <em>Reporter Name</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.IUserSettings#getReporterEmail <em>Reporter Email</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.IUserSettings#isAnonymizeMessages <em>Anonymize Messages</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.IUserSettings#isAnonymizeStackTraces <em>Anonymize Stack Traces</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.IUserSettings#isDisableAutomaticWiringAnalysis <em>Disable Automatic Wiring Analysis</em>}</li>
 * </ul>
 *
 * @see org.eclipse.epp.logging.aeri.core.IModelPackage#getUserSettings()
 * @model
 * @generated
 */
public interface IUserSettings extends EObject {
	/**
	 * Returns the value of the '<em><b>Reporter Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Reporter Id</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Reporter Id</em>' attribute.
	 * @see #setReporterId(String)
	 * @see org.eclipse.epp.logging.aeri.core.IModelPackage#getUserSettings_ReporterId()
	 * @model
	 * @generated
	 */
	String getReporterId();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.logging.aeri.core.IUserSettings#getReporterId <em>Reporter Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Reporter Id</em>' attribute.
	 * @see #getReporterId()
	 * @generated
	 */
	void setReporterId(String value);

	/**
	 * Returns the value of the '<em><b>Reporter Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Reporter Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Reporter Name</em>' attribute.
	 * @see #setReporterName(String)
	 * @see org.eclipse.epp.logging.aeri.core.IModelPackage#getUserSettings_ReporterName()
	 * @model
	 * @generated
	 */
	String getReporterName();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.logging.aeri.core.IUserSettings#getReporterName <em>Reporter Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Reporter Name</em>' attribute.
	 * @see #getReporterName()
	 * @generated
	 */
	void setReporterName(String value);

	/**
	 * Returns the value of the '<em><b>Reporter Email</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Reporter Email</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Reporter Email</em>' attribute.
	 * @see #setReporterEmail(String)
	 * @see org.eclipse.epp.logging.aeri.core.IModelPackage#getUserSettings_ReporterEmail()
	 * @model
	 * @generated
	 */
	String getReporterEmail();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.logging.aeri.core.IUserSettings#getReporterEmail <em>Reporter Email</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Reporter Email</em>' attribute.
	 * @see #getReporterEmail()
	 * @generated
	 */
	void setReporterEmail(String value);

	/**
	 * Returns the value of the '<em><b>Anonymize Messages</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Anonymize Messages</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Anonymize Messages</em>' attribute.
	 * @see #setAnonymizeMessages(boolean)
	 * @see org.eclipse.epp.logging.aeri.core.IModelPackage#getUserSettings_AnonymizeMessages()
	 * @model
	 * @generated
	 */
	boolean isAnonymizeMessages();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.logging.aeri.core.IUserSettings#isAnonymizeMessages <em>Anonymize Messages</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Anonymize Messages</em>' attribute.
	 * @see #isAnonymizeMessages()
	 * @generated
	 */
	void setAnonymizeMessages(boolean value);

	/**
	 * Returns the value of the '<em><b>Anonymize Stack Traces</b></em>' attribute.
	 * The default value is <code>"true"</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Anonymize Stack Traces</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Anonymize Stack Traces</em>' attribute.
	 * @see #setAnonymizeStackTraces(boolean)
	 * @see org.eclipse.epp.logging.aeri.core.IModelPackage#getUserSettings_AnonymizeStackTraces()
	 * @model default="true"
	 * @generated
	 */
	boolean isAnonymizeStackTraces();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.logging.aeri.core.IUserSettings#isAnonymizeStackTraces <em>Anonymize Stack Traces</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Anonymize Stack Traces</em>' attribute.
	 * @see #isAnonymizeStackTraces()
	 * @generated
	 */
	void setAnonymizeStackTraces(boolean value);

	/**
	 * Returns the value of the '<em><b>Disable Automatic Wiring Analysis</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Disable Automatic Wiring Analysis</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Disable Automatic Wiring Analysis</em>' attribute.
	 * @see #setDisableAutomaticWiringAnalysis(boolean)
	 * @see org.eclipse.epp.logging.aeri.core.IModelPackage#getUserSettings_DisableAutomaticWiringAnalysis()
	 * @model
	 * @generated
	 */
	boolean isDisableAutomaticWiringAnalysis();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.logging.aeri.core.IUserSettings#isDisableAutomaticWiringAnalysis <em>Disable Automatic Wiring Analysis</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Disable Automatic Wiring Analysis</em>' attribute.
	 * @see #isDisableAutomaticWiringAnalysis()
	 * @generated
	 */
	void setDisableAutomaticWiringAnalysis(boolean value);

} // IUserSettings
