/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.logging.aeri.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ProblemStatus implements Enumerator
{
    NEW(0, "NEW", "NEW"),
    CONFIRMED(1, "CONFIRMED", "CONFIRMED"),
    UNCONFIRMED(2, "UNCONFIRMED", "UNCONFIRMED"),
    NEEDINFO(3, "NEEDINFO", "NEEDINFO"),
    INVALID(4, "INVALID", "INVALID"),
    FIXED(5, "FIXED", "FIXED"),
    FAILURE(6, "FAILURE", "FAILURE"),
    IGNORED(7, "IGNORED", "IGNORED"),
    WONTFIX(8, "WONTFIX", "WONTFIX");

    public static final int NEW_VALUE = 0;
    public static final int CONFIRMED_VALUE = 1;
    public static final int UNCONFIRMED_VALUE = 2;
    public static final int NEEDINFO_VALUE = 3;
    public static final int INVALID_VALUE = 4;
    public static final int FIXED_VALUE = 5;
    public static final int FAILURE_VALUE = 6;
    public static final int IGNORED_VALUE = 7;
    public static final int WONTFIX_VALUE = 8;
    private static final ProblemStatus[] VALUES_ARRAY;
    public static final List<ProblemStatus> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ProblemStatus[]{NEW, CONFIRMED, UNCONFIRMED, NEEDINFO, INVALID, FIXED, FAILURE, IGNORED, WONTFIX};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ProblemStatus get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ProblemStatus result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ProblemStatus getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ProblemStatus result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ProblemStatus get(int value) {
        switch (value) {
            case 0: {
                return NEW;
            }
            case 1: {
                return CONFIRMED;
            }
            case 2: {
                return UNCONFIRMED;
            }
            case 3: {
                return NEEDINFO;
            }
            case 4: {
                return INVALID;
            }
            case 5: {
                return FIXED;
            }
            case 6: {
                return FAILURE;
            }
            case 7: {
                return IGNORED;
            }
            case 8: {
                return WONTFIX;
            }
        }
        return null;
    }

    private ProblemStatus(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

