/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.util.QuotedString;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.StopOptionHandler;

@Command(common=true, usage="usage_LsFiles")
class LsFiles
extends TextBuiltin {
    @Option(name="--", metaVar="metaVar_paths", handler=StopOptionHandler.class)
    private List<String> paths = new ArrayList<String>();

    LsFiles() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void run() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            TreeWalk tw;
            RevWalk rw = new RevWalk(this.db);
            try {
                ObjectId head;
                block16: {
                    block17: {
                        tw = new TreeWalk(this.db);
                        head = this.db.resolve("HEAD");
                        if (head != null) break block16;
                        if (tw == null) break block17;
                        tw.close();
                    }
                    if (rw == null) return;
                    rw.close();
                    return;
                }
                RevCommit c = rw.parseCommit((AnyObjectId)head);
                CanonicalTreeParser p = new CanonicalTreeParser();
                p.reset(rw.getObjectReader(), (AnyObjectId)c.getTree());
                tw.reset();
                if (this.paths.size() > 0) {
                    tw.setFilter(PathFilterGroup.createFromStrings(this.paths));
                }
                tw.addTree((AbstractTreeIterator)p);
                tw.addTree((AbstractTreeIterator)new DirCacheIterator(this.db.readDirCache()));
                tw.setRecursive(true);
                while (tw.next()) {
                    if (!this.filterFileMode(tw, FileMode.EXECUTABLE_FILE, FileMode.GITLINK, FileMode.REGULAR_FILE, FileMode.SYMLINK)) continue;
                    this.outw.println(QuotedString.GIT_PATH.quote(tw.getPathString()));
                }
                break block18;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (rw == null) throw throwable;
                rw.close();
                throw throwable;
            }
            {
                block18: {
                    finally {
                        if (tw != null) {
                            tw.close();
                        }
                    }
                }
                if (rw == null) return;
            }
            rw.close();
            return;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    private boolean filterFileMode(TreeWalk tw, FileMode ... modes) {
        return Arrays.stream(modes).anyMatch(Predicate.isEqual(tw.getFileMode(0)).or(Predicate.isEqual(tw.getFileMode(1))));
    }
}

