/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm.opt;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.pgm.opt.CmdLineParser;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.util.FS;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.Localizable;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

public class AbstractTreeIteratorHandler
extends OptionHandler<AbstractTreeIterator> {
    private final CmdLineParser clp;

    public AbstractTreeIteratorHandler(org.kohsuke.args4j.CmdLineParser parser, OptionDef option, Setter<? super AbstractTreeIterator> setter) {
        super(parser, option, setter);
        this.clp = (CmdLineParser)parser;
    }

    public int parseArguments(Parameters params) throws CmdLineException {
        ObjectId id;
        String name = params.getParameter(0);
        if (new File(name).isDirectory()) {
            this.setter.addValue((Object)new FileTreeIterator(new File(name), FS.DETECTED, (WorkingTreeOptions)this.clp.getRepository().getConfig().get(WorkingTreeOptions.KEY)));
            return 1;
        }
        if (new File(name).isFile()) {
            DirCache dirc;
            try {
                dirc = DirCache.read((File)new File(name), (FS)FS.DETECTED);
            }
            catch (IOException e) {
                throw new CmdLineException((org.kohsuke.args4j.CmdLineParser)this.clp, MessageFormat.format(CLIText.get().notAnIndexFile, name), (Throwable)e);
            }
            this.setter.addValue((Object)new DirCacheIterator(dirc));
            return 1;
        }
        try {
            id = this.clp.getRepository().resolve(name);
        }
        catch (IOException e) {
            throw new CmdLineException((org.kohsuke.args4j.CmdLineParser)this.clp, (Localizable)CLIText.format(e.getMessage()), new String[0]);
        }
        if (id == null) {
            throw new CmdLineException((org.kohsuke.args4j.CmdLineParser)this.clp, (Localizable)CLIText.format(CLIText.get().notATree), new String[]{name});
        }
        CanonicalTreeParser p = new CanonicalTreeParser();
        try {
            Throwable throwable = null;
            Object var6_13 = null;
            try (ObjectReader curs = this.clp.getRepository().newObjectReader();){
                p.reset(curs, (AnyObjectId)this.clp.getRevWalk().parseTree((AnyObjectId)id));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (MissingObjectException e) {
            throw new CmdLineException((org.kohsuke.args4j.CmdLineParser)this.clp, (Localizable)CLIText.format(CLIText.get().notATree), new String[]{name});
        }
        catch (IncorrectObjectTypeException e) {
            throw new CmdLineException((org.kohsuke.args4j.CmdLineParser)this.clp, (Localizable)CLIText.format(CLIText.get().notATree), new String[]{name});
        }
        catch (IOException e) {
            throw new CmdLineException((org.kohsuke.args4j.CmdLineParser)this.clp, (Localizable)CLIText.format(CLIText.get().cannotReadBecause), new String[]{name, e.getMessage()});
        }
        this.setter.addValue((Object)p);
        return 1;
    }

    public String getDefaultMetaVariable() {
        return CLIText.get().metaVar_treeish;
    }
}

