/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.teststyle.checks.contexts;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseContext
implements Comparable<BaseContext> {
    private static Set<BaseContext> contexts = new HashSet<BaseContext>();
    private Class<?> m_context;

    public BaseContext(Class<?> cls) {
        this.m_context = cls;
        contexts.add(this);
    }

    public abstract String getName();

    public abstract String getDescription();

    public Class<?> getContext() {
        return this.m_context;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BaseContext) {
            BaseContext other = (BaseContext)obj;
            return other.m_context.equals(this.m_context);
        }
        return false;
    }

    public int hashCode() {
        return this.m_context.hashCode();
    }

    public abstract List<? extends Object> getAll();

    public static BaseContext getFor(Class<?> cls) {
        for (BaseContext context : contexts) {
            if (!context.getContext().isAssignableFrom(cls)) continue;
            return context;
        }
        return null;
    }

    public static BaseContext getFor(String str) {
        for (BaseContext context : contexts) {
            if (!context.getClass().getSimpleName().equals(str)) continue;
            return context;
        }
        return null;
    }

    @Override
    public int compareTo(BaseContext o) {
        String left = this.getClass().getName();
        String right = o.getClass().getName();
        return left.compareTo(right);
    }
}

