/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.views.nodes;

import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.m2e.core.internal.index.nexus.IndexedArtifactGroup;
import org.eclipse.m2e.core.internal.index.nexus.NexusIndex;
import org.eclipse.m2e.core.ui.internal.MavenImages;
import org.eclipse.m2e.core.ui.internal.views.nodes.IMavenRepositoryNode;
import org.eclipse.m2e.core.ui.internal.views.nodes.IndexedArtifactGroupNode;
import org.eclipse.swt.graphics.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIndexedRepositoryNode
implements IMavenRepositoryNode {
    private static final Logger log = LoggerFactory.getLogger(AbstractIndexedRepositoryNode.class);
    protected static final Object[] NO_CHILDREN = new Object[0];
    protected final NexusIndex index;

    protected AbstractIndexedRepositoryNode(NexusIndex index) {
        this.index = index;
    }

    @Override
    public Object[] getChildren() {
        if (this.index == null) {
            return NO_CHILDREN;
        }
        try {
            Object[] rootGroups = this.index.getRootIndexedArtifactGroups();
            if (rootGroups == null) {
                return NO_CHILDREN;
            }
            Object[] children = new IndexedArtifactGroupNode[rootGroups.length];
            Arrays.sort(rootGroups);
            int i = 0;
            while (i < rootGroups.length) {
                children[i] = new IndexedArtifactGroupNode((IndexedArtifactGroup)rootGroups[i]);
                ++i;
            }
            return children;
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return NO_CHILDREN;
        }
    }

    @Override
    public Image getImage() {
        return MavenImages.IMG_INDEX;
    }

    @Override
    public boolean hasChildren() {
        return this.index != null;
    }

    @Override
    public boolean isUpdating() {
        return this.index != null && this.index.isUpdating();
    }

    public NexusIndex getIndex() {
        return this.index;
    }

    public String getRepositoryUrl() {
        return this.index.getRepositoryUrl();
    }

    public boolean isEnabledIndex() {
        return this.index != null && this.index.isEnabled();
    }
}

