/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm.nativelib;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.m2m.atl.engine.vm.StackFrame;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMBoolean;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMCollection;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclSimpleType;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclType;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclUndefined;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMSequence;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMTransientLink;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMTuple;

public class ASMTransientLinkSet
extends ASMOclAny {
    public static ASMOclType myType = new ASMOclSimpleType("TransientLinkSet", ASMTransientLinkSet.getOclAnyType());
    private Map linksByRule = new HashMap();
    private Map linksBySourceElementByRule = new HashMap();
    private Map linksBySourceElement = new HashMap();
    private Map linksByTargetElement = new HashMap();
    private ASMSequence links = new ASMSequence();

    public ASMTransientLinkSet() {
        super(myType);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer("TransientLinkSet {");
        Iterator i = this.linksBySourceElement.values().iterator();
        while (i.hasNext()) {
            ret.append(i.next());
            if (!i.hasNext()) continue;
            ret.append(", ");
        }
        ret.append("}");
        return ret.toString();
    }

    public static void addLink(StackFrame frame, ASMTransientLinkSet self, ASMTransientLink link) {
        ASMTransientLinkSet.addLink2(frame, self, link, new ASMBoolean(true));
    }

    public static void addLink2(StackFrame frame, ASMTransientLinkSet self, ASMTransientLink link, ASMBoolean isDefault) {
        ASMOclAny rule = ASMTransientLink.getRule(frame, link);
        ASMSequence s = (ASMSequence)self.linksByRule.get(rule);
        if (s == null) {
            s = new ASMSequence();
            self.linksByRule.put(rule, s);
        }
        self.links.add(link);
        s.add(link);
        HashMap linksBySourceElements2 = (HashMap)self.linksBySourceElementByRule.get(rule);
        if (linksBySourceElements2 == null) {
            linksBySourceElements2 = new HashMap();
            self.linksBySourceElementByRule.put(rule, linksBySourceElements2);
        }
        Iterator i = link.getSourceElements().iterator();
        while (i.hasNext()) {
            Object e = i.next();
            linksBySourceElements2.put(e, link);
        }
        if (isDefault.getSymbol()) {
            ASMTuple se;
            if (link.getSourceElements().size() == 1) {
                se = link.getSourceElements().iterator().next();
            } else {
                se = new ASMTuple();
                Iterator i2 = link.getSourceMap().keySet().iterator();
                while (i2.hasNext()) {
                    String k = (String)i2.next();
                    se.set(frame, k, (ASMOclAny)link.getSourceMap().get(k));
                }
            }
            ASMTransientLink other = (ASMTransientLink)self.linksBySourceElement.get(se);
            if (other != null) {
                frame.printStackTrace("Trying to register several rules as default for element " + se + ": " + ASMTransientLink.getRule(frame, other) + " and " + rule);
            }
            self.linksBySourceElement.put(se, link);
        }
        i = link.getTargetElements().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof ASMCollection) {
                Iterator j = ((ASMCollection)o).iterator();
                while (j.hasNext()) {
                    self.linksByTargetElement.put(j.next(), link);
                }
                continue;
            }
            self.linksByTargetElement.put(o, link);
        }
    }

    public static ASMSequence getLinksByRule(StackFrame frame, ASMTransientLinkSet self, ASMOclAny rule) {
        ASMSequence ret = (ASMSequence)self.linksByRule.get(rule);
        if (ret == null) {
            ret = new ASMSequence();
        }
        return ret;
    }

    public static ASMOclAny getLinkBySourceElement(StackFrame frame, ASMTransientLinkSet self, ASMOclAny sourceElement) {
        ASMOclAny ret = (ASMOclAny)self.linksBySourceElement.get(sourceElement);
        if (ret == null) {
            ret = new ASMOclUndefined();
        }
        return ret;
    }

    public static ASMOclAny getLinkByRuleAndSourceElement(StackFrame frame, ASMTransientLinkSet self, ASMOclAny rule, ASMOclAny sourceElement) {
        Map map = (Map)self.linksBySourceElementByRule.get(rule);
        ASMOclAny ret = null;
        if (map != null) {
            ret = (ASMOclAny)map.get(sourceElement);
        }
        if (ret == null) {
            ret = new ASMOclUndefined();
        }
        return ret;
    }

    public static ASMOclAny getLinkByTargetElement(StackFrame frame, ASMTransientLinkSet self, ASMOclAny targetElement) {
        ASMOclAny ret = (ASMOclAny)self.linksByTargetElement.get(targetElement);
        if (ret == null) {
            ret = new ASMOclUndefined();
        }
        return ret;
    }

    public static ASMSequence getAllLinks(StackFrame frame, ASMTransientLinkSet self) {
        return self.links;
    }
}

