/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.tools.coverage.common;

import java.io.Serializable;
import java.util.HashSet;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.expressions.Constructor;
import org.eclipse.m2m.internal.qvt.oml.expressions.Helper;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingOperation;
import org.eclipse.m2m.internal.qvt.oml.tools.coverage.common.NodeData;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.AssignExp;
import org.eclipse.ocl.ecore.InvalidLiteralExp;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.utilities.ASTNode;

public class TransformationCoverageData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String transfUri;
    private final HashSet<NodeData> touched;
    private transient boolean isModified;

    private static boolean isIncluded(OCLExpression node) {
        return !(node.eContainer() instanceof AssignExp) || !((AssignExp)node.eContainer()).getLeft().equals(node);
    }

    public static boolean isIncluded(ASTNode node) {
        return !(node instanceof InvalidLiteralExp) && (node instanceof MappingOperation || node instanceof Helper || node instanceof Constructor || node instanceof OCLExpression && TransformationCoverageData.isIncluded((OCLExpression)node));
    }

    public TransformationCoverageData(URI uri) {
        this.transfUri = uri.toString();
        this.touched = new HashSet();
        this.isModified = true;
    }

    public URI getURI() {
        return URI.createURI((String)this.transfUri);
    }

    public boolean containsNode(ASTNode node) {
        return this.touched.contains(new NodeData(node));
    }

    public void touch(ASTNode element) {
        if (TransformationCoverageData.isIncluded(element)) {
            this.touched.add(new NodeData(element));
            this.isModified = true;
        }
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void setModified(boolean modified) {
        this.isModified = modified;
    }
}

