/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui.issue;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.mylyn.internal.github.ui.GitHubImages;
import org.eclipse.mylyn.internal.github.ui.issue.Messages;
import org.eclipse.mylyn.internal.tasks.ui.notifications.TaskDiffUtil;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class IssueLabelAttributeEditor
extends AbstractAttributeEditor {
    public static final int LABEL_WIDTH = 80;
    public static final int LABEL_COLUMNS = 12;
    private Composite displayArea;
    private boolean layout = false;
    private Composite labelsArea;
    private List<CLabel> labelControls = new LinkedList<CLabel>();
    private FormToolkit toolkit;
    private Comparator<String> labelComparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }
    };

    public IssueLabelAttributeEditor(TaskDataModel manager, TaskAttribute taskAttribute) {
        super(manager, taskAttribute);
        this.setLayoutHint(new LayoutHint(LayoutHint.RowSpan.SINGLE, LayoutHint.ColumnSpan.MULTIPLE));
    }

    private void refreshLabels() {
        for (CLabel labelControl : this.labelControls) {
            labelControl.dispose();
        }
        this.labelControls.clear();
        Image labelImage = GitHubImages.get("org.eclipse.mylyn.github.uiOBJ_GITHUB_ISSUE_LABEL");
        LinkedList labels = new LinkedList(this.getTaskAttribute().getValues());
        Collections.sort(labels, this.labelComparator);
        if (!labels.isEmpty()) {
            for (final String label : labels) {
                CLabel cLabel = new CLabel(this.labelsArea, 0);
                MenuManager manager = new MenuManager();
                manager.setRemoveAllWhenShown(true);
                manager.addMenuListener(new IMenuListener(){

                    public void menuAboutToShow(IMenuManager manager) {
                        manager.add((IAction)new RemoveLabelAction(label));
                    }
                });
                Menu menu = manager.createContextMenu((Control)cLabel);
                cLabel.setMenu(menu);
                String shortened = TaskDiffUtil.shortenText((Drawable)this.displayArea, (String)label, (int)80);
                cLabel.setImage(labelImage);
                cLabel.setText(shortened);
                cLabel.setForeground(this.toolkit.getColors().getForeground());
                if (!shortened.equals(label)) {
                    cLabel.setToolTipText(label);
                }
                this.labelControls.add(cLabel);
            }
        } else {
            this.labelControls.add(new CLabel(this.labelsArea, 0));
        }
        if (this.layout) {
            this.displayArea.getParent().getParent().layout(true, true);
        }
    }

    private void markLabelsChanged() {
        this.getModel().attributeChanged(this.getTaskAttribute());
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        this.toolkit = toolkit;
        this.displayArea = toolkit.createComposite(parent);
        this.displayArea.setBackgroundMode(2);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.displayArea);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.displayArea);
        final ToolBar toolbar = new ToolBar(this.displayArea, 0x800000);
        toolkit.adapt((Control)toolbar, false, false);
        final ToolItem addItem = new ToolItem(toolbar, 4);
        addItem.setImage(GitHubImages.get("org.eclipse.mylyn.github.uiGITHUB_ADD_OBJ"));
        addItem.setToolTipText(Messages.IssueLabelAttributeEditor_TooltipAddLabel);
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)new NewLabelAction());
                manager.add((IContributionItem)new Separator());
                LinkedList labels = new LinkedList(IssueLabelAttributeEditor.this.getTaskAttribute().getOptions().values());
                labels.removeAll(IssueLabelAttributeEditor.this.getTaskAttribute().getValues());
                for (String label : labels) {
                    manager.add((IAction)new LabelAction(label));
                }
                manager.update();
            }
        });
        final Menu menu = manager.createContextMenu((Control)this.displayArea);
        addItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rectangle toolItemBounds = addItem.getBounds();
                Point location = toolbar.toDisplay(toolItemBounds.x, toolItemBounds.y + toolItemBounds.height);
                menu.setLocation(location);
                menu.setVisible(true);
            }
        });
        this.labelsArea = toolkit.createComposite(this.displayArea);
        this.labelsArea.setBackgroundMode(2);
        this.labelsArea.setBackground(null);
        GridLayoutFactory.fillDefaults().numColumns(12).applyTo(this.labelsArea);
        GridDataFactory.swtDefaults().grab(true, true).applyTo((Control)this.labelsArea);
        this.refreshLabels();
        this.setControl((Control)this.displayArea);
        this.layout = true;
    }

    private class LabelAction
    extends Action {
        public LabelAction(String label) {
            super(label, 1);
            this.setImageDescriptor(GitHubImages.DESC_GITHUB_ISSUE_LABEL);
        }

        public void run() {
            if (!IssueLabelAttributeEditor.this.getTaskAttribute().getValues().contains(this.getText())) {
                IssueLabelAttributeEditor.this.getTaskAttribute().addValue(this.getText());
                IssueLabelAttributeEditor.this.markLabelsChanged();
                IssueLabelAttributeEditor.this.refreshLabels();
            }
        }
    }

    private class NewLabelAction
    extends Action {
        public NewLabelAction() {
            super(Messages.IssueLabelAttributeEditor_ActionNewLabel, 1);
        }

        public void run() {
            InputDialog dialog = new InputDialog(IssueLabelAttributeEditor.this.getControl().getShell(), Messages.IssueLabelAttributeEditor_TitleNewLabel, Messages.IssueLabelAttributeEditor_DescriptionNewLabel, "", new IInputValidator(){

                public String isValid(String newText) {
                    if (newText == null || newText.trim().length() == 0) {
                        return Messages.IssueLabelAttributeEditor_MessageEnterName;
                    }
                    return null;
                }
            });
            if (dialog.open() == 0 && !IssueLabelAttributeEditor.this.getTaskAttribute().getValues().contains(dialog.getValue())) {
                IssueLabelAttributeEditor.this.getTaskAttribute().addValue(dialog.getValue());
                IssueLabelAttributeEditor.this.markLabelsChanged();
                IssueLabelAttributeEditor.this.refreshLabels();
            }
        }
    }

    private class RemoveLabelAction
    extends Action {
        private String label;

        public RemoveLabelAction(String label) {
            super(Messages.IssueLabelAttributeEditor_ActionRemoveLabel, 1);
            this.label = label;
        }

        public void run() {
            if (IssueLabelAttributeEditor.this.getTaskAttribute().getValues().contains(this.label)) {
                IssueLabelAttributeEditor.this.getTaskAttribute().removeValue(this.label);
                IssueLabelAttributeEditor.this.markLabelsChanged();
                IssueLabelAttributeEditor.this.refreshLabels();
            }
        }
    }
}

