/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.om.trace;

import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.om.trace.OMTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerfTracer
extends ContextTracer {
    public static final long NOT_STARTED = 0L;
    private Map<Object, Long> timers = new IdentityHashMap<Object, Long>();

    public PerfTracer(OMTracer delegate, Class<?> context) {
        super(delegate, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Object object) {
        if (this.isEnabled()) {
            Map<Object, Long> map = this.timers;
            synchronized (map) {
                this.timers.put(object, System.currentTimeMillis());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long stop(Object object) {
        long duration = 0L;
        if (this.isEnabled()) {
            Long timer;
            Map<Object, Long> map = this.timers;
            synchronized (map) {
                timer = this.timers.remove(object);
            }
            if (timer != null) {
                duration = System.currentTimeMillis() - timer;
                this.format("{0} = {1} millis", object, duration);
            }
        }
        return duration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDuration(Object object) {
        long duration = 0L;
        if (this.isEnabled()) {
            Long timer;
            Map<Object, Long> map = this.timers;
            synchronized (map) {
                timer = this.timers.get(object);
            }
            if (timer != null) {
                duration = System.currentTimeMillis() - timer;
            }
        }
        return duration;
    }
}

