/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.util.pde.core.internal;

import com.ibm.icu.lang.UCharacter;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.emf.facet.util.core.Logger;
import org.eclipse.papyrus.emf.facet.util.core.internal.exported.FileUtils;
import org.eclipse.papyrus.emf.facet.util.core.internal.exported.FolderUtils;
import org.eclipse.papyrus.emf.facet.util.core.internal.exported.IFilter;
import org.eclipse.papyrus.emf.facet.util.pde.core.internal.Activator;
import org.eclipse.papyrus.emf.facet.util.pde.core.internal.BuildPropertiesUtils;
import org.eclipse.pde.core.plugin.IExtensions;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.osgi.framework.Bundle;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PluginUtils {
    private static final String JAVA_VERSION = "J2SE-1.5";
    private static final String ACTIVATOR_NAME = "Activator";
    private static final String MANIFEST_MF_TPL = "resources/MANIFEST.MF.template";
    private static final String ACTIVATOR_TPL = "resources/Activator.java.template";
    private static final String PDE_CLASSPATH_ID = "org.eclipse.pde.core.requiredPlugins";
    private static final String PLUGIN_NATURE = "org.eclipse.pde.PluginNature";

    private PluginUtils() {
    }

    public static boolean isRegistered(IFile elementFile, String extensionPoint) {
        IProject project = elementFile.getProject();
        IPluginModelBase pluginModel = PluginRegistry.findModel((IProject)project);
        boolean result = false;
        if (pluginModel != null) {
            IPluginExtension[] extensions;
            IExtensions extensions2 = pluginModel.getExtensions();
            IPluginExtension[] iPluginExtensionArray = extensions = extensions2.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginExtension pluginExtension = iPluginExtensionArray[n2];
                if (extensionPoint.equals(pluginExtension.getPoint())) {
                    IPluginObject[] children;
                    IPluginObject[] iPluginObjectArray = children = pluginExtension.getChildren();
                    int n3 = children.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPluginObject child = iPluginObjectArray[n4];
                        if (child instanceof IPluginElement) {
                            IPluginAttribute[] attributes;
                            IPluginElement pluginElement = (IPluginElement)child;
                            IPluginAttribute[] iPluginAttributeArray = attributes = pluginElement.getAttributes();
                            int n5 = attributes.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IFile file;
                                String strFile;
                                IPluginAttribute pluginAttribute = iPluginAttributeArray[n6];
                                if ("file".equalsIgnoreCase(pluginAttribute.getName()) && (strFile = pluginAttribute.getValue()) != null && strFile.length() > 0 && (file = project.getFile(strFile)).exists() && elementFile.equals((Object)file)) {
                                    result = true;
                                }
                                ++n6;
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    public static void register(IFile file, String extensionPointId, String elementName) {
        if (PluginUtils.isRegistered(file, extensionPointId)) {
            return;
        }
        IPath filePath = file.getFullPath().removeFirstSegments(1);
        IProject project = file.getProject();
        IFile pluginXML = project.getFile("plugin.xml");
        if (pluginXML.exists()) {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                String pluginXmlLoc = pluginXML.getLocation().toOSString();
                Document doc = docBuilder.parse(pluginXmlLoc);
                Element root = doc.getDocumentElement();
                Text whitespace = doc.createTextNode("   ");
                root.appendChild(whitespace);
                Element extensionNode = doc.createElement("extension");
                Attr pointAttr = doc.createAttribute("point");
                pointAttr.setValue(extensionPointId);
                extensionNode.getAttributes().setNamedItem(pointAttr);
                root.appendChild(extensionNode);
                Element elementNode = doc.createElement(elementName);
                Attr fileAttr = doc.createAttribute("file");
                fileAttr.setValue(filePath.toString());
                elementNode.getAttributes().setNamedItem(fileAttr);
                extensionNode.appendChild(elementNode);
                TransformerFactory trFactory = TransformerFactory.newInstance();
                int indent = 3;
                trFactory.setAttribute("indent-number", 3);
                Transformer transformer = trFactory.newTransformer();
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("indent", "yes");
                StreamResult result = new StreamResult(new StringWriter());
                DOMSource source = new DOMSource(doc);
                transformer.transform(source, result);
                String xmlString = result.getWriter().toString();
                byte[] byteArray = xmlString.getBytes("UTF-8");
                pluginXML.setContents((InputStream)new ByteArrayInputStream(byteArray), true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        } else {
            try {
                String template = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<?eclipse version=\"3.4\"?>\n<plugin>\n   <extension point=\"{0}\">\n      <{1} file=\"{2}\"/>\n   </extension>\n</plugin>\n";
                String content = NLS.bind((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<?eclipse version=\"3.4\"?>\n<plugin>\n   <extension point=\"{0}\">\n      <{1} file=\"{2}\"/>\n   </extension>\n</plugin>\n", (Object[])new Object[]{extensionPointId, elementName, filePath.toString()});
                byte[] byteArray = content.getBytes("UTF-8");
                pluginXML.create((InputStream)new ByteArrayInputStream(byteArray), true, (IProgressMonitor)new NullProgressMonitor());
                try {
                    BuildPropertiesUtils.addToBuild(pluginXML);
                }
                catch (Exception e) {
                    Logger.logError((Throwable)e, (String)("Error adding file " + pluginXML.getFullPath() + " to the build.properties"), null);
                }
            }
            catch (Exception e) {
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
    }

    private static void addPdeClassPath(IProject project) throws JavaModelException {
        IClasspathEntry[] oldClassPath;
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IClasspathEntry[] iClasspathEntryArray = oldClassPath = javaProject.getRawClasspath();
        int n = oldClassPath.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
            if (classpathEntry.getPath().equals((Object)new Path(PDE_CLASSPATH_ID))) {
                return;
            }
            ++n2;
        }
        IClasspathEntry[] newClassPath = new IClasspathEntry[oldClassPath.length + 1];
        System.arraycopy(oldClassPath, 0, newClassPath, 0, oldClassPath.length);
        newClassPath[oldClassPath.length] = JavaCore.newContainerEntry((IPath)new Path(PDE_CLASSPATH_ID));
        javaProject.setRawClasspath(newClassPath, (IProgressMonitor)new NullProgressMonitor());
    }

    private static void createManifest(IProject project) throws CoreException, IOException {
        IFile manifestFile;
        IFolder folder = project.getFolder("META-INF");
        if (!folder.exists()) {
            folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        if (!(manifestFile = folder.getFile("MANIFEST.MF")).exists()) {
            String template = FileUtils.getFileContents((Bundle)Activator.getDefault().getBundle(), (String)MANIFEST_MF_TPL);
            template = template.replace("{projectName}", project.getName());
            String packageName = PluginUtils.stringToValidPackageName(project.getName());
            template = template.replace("{packageName}", packageName);
            String activator = PluginUtils.bundleActivatorQualifiedName(packageName);
            template = template.replace("{activator}", activator);
            template = template.replace("{javaVersion}", JAVA_VERSION);
            ByteArrayInputStream source = new ByteArrayInputStream(template.getBytes());
            manifestFile.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private static String bundleActivatorQualifiedName(String packageName) {
        return String.valueOf(packageName) + '.' + ACTIVATOR_NAME;
    }

    private static void createActivator(IProject project) throws CoreException, IOException {
        String packageName = PluginUtils.stringToValidPackageName(project.getName());
        String qualifiedName = PluginUtils.bundleActivatorQualifiedName(packageName);
        String path = qualifiedName.replaceAll("\\.", "/");
        IFile activatorFile = project.getFile(new Path("src").append(path).addFileExtension("java"));
        FolderUtils.createFolder((IFolder)((IFolder)activatorFile.getParent()));
        if (!activatorFile.exists()) {
            String template = FileUtils.getFileContents((Bundle)Activator.getDefault().getBundle(), (String)ACTIVATOR_TPL);
            String activatorContents = template.replace("{0}", packageName);
            ByteArrayInputStream source = new ByteArrayInputStream(activatorContents.getBytes());
            activatorFile.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private static String stringToValidPackageName(String name) {
        IStatus status;
        StringBuilder builder = new StringBuilder();
        int prev = 32;
        int i = 0;
        while (i < name.length()) {
            char character = name.charAt(i);
            if (character >= 'a' && character <= 'z' || character >= 'A' && character <= 'Z' || character == '_') {
                builder.append(character);
                prev = character;
            } else if (character >= '0' && character <= '9') {
                if (builder.length() == 0 || prev == 46) {
                    builder.append("_");
                }
                builder.append(character);
                prev = character;
            } else if (character == '.') {
                if (prev != 46) {
                    if (builder.length() == 0 || prev >= 48 && prev <= 57) {
                        builder.append("_");
                    }
                    builder.append(character);
                    prev = character;
                }
            } else {
                builder.append("_");
            }
            ++i;
        }
        String result = builder.toString();
        if (result.length() > 0 && UCharacter.isUpperCase((int)result.charAt(0))) {
            result = String.valueOf(UCharacter.toLowerCase((int)result.charAt(0))) + result.substring(1);
        }
        if (!(status = JavaConventions.validatePackageName((String)result, (String)"1.5", (String)"1.5")).isOK()) {
            Logger.logWarning((String)("Couldn't make valid package name from project name: " + status.getMessage()), (Plugin)Activator.getDefault());
            result = name;
        }
        return result;
    }

    private static void addPdeNature(IProject project) throws CoreException {
        String pluginNature = PLUGIN_NATURE;
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        if (!Arrays.asList(natures).contains(PLUGIN_NATURE)) {
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[natures.length] = PLUGIN_NATURE;
            description.setNatureIds(newNatures);
            project.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static void configureAsPluginProject(IProject project) throws CoreException, IOException {
        PluginUtils.addPdeNature(project);
        PluginUtils.addPdeClassPath(project);
        PluginUtils.createManifest(project);
        PluginUtils.createActivator(project);
    }

    public static boolean isPluginProject(IProject project) throws CoreException {
        boolean result = false;
        if (project.isAccessible()) {
            result = project.getNature(PLUGIN_NATURE) != null;
        }
        return result;
    }

    public static boolean isInPluginProject(IPath path) throws CoreException {
        IProject project;
        if (path.segmentCount() == 1) {
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
        } else {
            IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
            project = folder.getProject();
        }
        return PluginUtils.isPluginProject(project);
    }

    public static IProject importPlugin(Bundle bundle) throws CoreException {
        return PluginUtils.importPlugin(bundle, new IFilter<String>(){

            public boolean filter(String fileName) {
                return true;
            }
        });
    }

    public static IProject importPlugin(final Bundle bundle, final IFilter<String> filter) throws CoreException {
        final IProject[] project = new IProject[1];
        IWorkspaceRunnable workspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                project[0] = PluginUtils.internalImportPlugin(bundle, (IFilter<String>)filter);
            }
        };
        ResourcesPlugin.getWorkspace().run(workspaceRunnable, (IProgressMonitor)new NullProgressMonitor());
        return project[0];
    }

    protected static IProject internalImportPlugin(Bundle bundle, IFilter<String> filter) throws CoreException {
        IProject project = PluginUtils.createProjectWithUniqueName(bundle.getSymbolicName());
        ArrayList<IStatus> errors = new ArrayList<IStatus>();
        List<URL> urls = PluginUtils.getURLsToCopy(bundle, project, "/", filter, errors);
        for (URL url : urls) {
            PluginUtils.copyUrlToFile(project, errors, url);
        }
        PluginUtils.handleErrors(errors);
        project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        project.build(15, (IProgressMonitor)new NullProgressMonitor());
        project.build(6, (IProgressMonitor)new NullProgressMonitor());
        return project;
    }

    private static void copyUrlToFile(IProject project, List<IStatus> errors, URL url) throws CoreException {
        try {
            IContainer parent;
            InputStream inputStream = url.openStream();
            String strSubpath = url.toString().replaceAll("bundleentry://[^/]*/", "");
            IFile file = project.getFile((IPath)new Path(strSubpath));
            if (file.exists()) {
                file.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            if (!(parent = file.getParent()).exists() && parent instanceof IFolder) {
                PluginUtils.createDir((IFolder)parent);
            }
            file.create(inputStream, true, (IProgressMonitor)new NullProgressMonitor());
            inputStream.close();
        }
        catch (FileNotFoundException e) {
            String message;
            try {
                message = String.format("Ignoring the missing file %s.", url.toURI());
            }
            catch (URISyntaxException e1) {
                message = String.format("Ignoring the missing file.", new Object[0]);
            }
            Logger.logError((String)message, (Plugin)Activator.getDefault());
        }
        catch (IOException e) {
            Bundle localBundle = Activator.getDefault().getBundle();
            String symbolicName = localBundle.getSymbolicName();
            Status status = new Status(4, symbolicName, e.getMessage(), (Throwable)e);
            errors.add((IStatus)status);
        }
    }

    private static void createDir(IFolder folder) throws CoreException {
        IContainer parent = folder.getParent();
        if (!parent.exists() && parent instanceof IFolder) {
            PluginUtils.createDir((IFolder)parent);
        }
        folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
    }

    protected static void handleErrors(List<IStatus> errors) throws CoreException {
        if (!errors.isEmpty()) {
            IStatus[] statusArray = errors.toArray(new IStatus[errors.size()]);
            MultiStatus status = new MultiStatus(Activator.getDefault().getBundle().getSymbolicName(), 4, statusArray, "Errors importing project", (Throwable)new Exception());
            throw new CoreException((IStatus)status);
        }
    }

    private static List<URL> getURLsToCopy(Bundle bundle, IProject project, String path, IFilter<String> filter, List<IStatus> errors) {
        ArrayList<URL> result = new ArrayList<URL>();
        Enumeration entryPaths = bundle.getEntryPaths(path);
        while (entryPaths != null && entryPaths.hasMoreElements()) {
            String strSubpath;
            Object nextElement = entryPaths.nextElement();
            if (!(nextElement instanceof String) || !filter.filter((Object)(strSubpath = (String)nextElement))) continue;
            if (strSubpath.endsWith("/")) {
                List<URL> fromSubFolder = PluginUtils.getURLsToCopy(bundle, project, strSubpath, filter, errors);
                result.addAll(fromSubFolder);
                continue;
            }
            URL url = bundle.getEntry(strSubpath);
            if (url == null) continue;
            result.add(url);
        }
        return result;
    }

    protected static IProject createProjectWithUniqueName(String baseName) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject project = root.getProject(baseName);
        if (project.exists()) {
            int version = 1;
            int maxIter = 100;
            while (project.exists() && version < 100) {
                String uniqueName = String.valueOf(baseName) + " (" + version + ')';
                project = root.getProject(uniqueName);
                ++version;
            }
        }
        project.create((IProgressMonitor)new NullProgressMonitor());
        project.open((IProgressMonitor)new NullProgressMonitor());
        return project;
    }
}

