/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.configuration.handler;

import java.util.List;
import java.util.Map;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.infra.gmfdiag.css.configuration.handler.AbstractStyleDialog;
import org.eclipse.papyrus.infra.gmfdiag.css.configuration.helper.DiagramTypeHelper;
import org.eclipse.papyrus.infra.gmfdiag.css.configuration.providers.ExistingStyleContentProvider;
import org.eclipse.papyrus.infra.gmfdiag.css.configuration.providers.StylesheetLabelProvider;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.AttributeSelector;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.ClassSelector;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.CssSelector;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.css_declaration;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.ruleset;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.selector;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.simple_selector;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.stylesheet;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class StyleEditionDialog
extends AbstractStyleDialog
implements ISelectionChangedListener {
    protected Composite styleSelectionPanel;
    protected Composite styleEditionPanel;
    protected ruleset ruleset;

    public StyleEditionDialog(Shell shell, Map<AttributeSelector, Boolean> conditions, Map<css_declaration, Boolean> declarations, String selectorName, View context) {
        super(shell, conditions, declarations, selectorName, context);
    }

    @Override
    public void create() {
        super.create();
        this.createStyleSelectionPanel();
        this.getShell().setText("Edit an existing style");
    }

    public Composite createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        SashForm sash = new SashForm(dialogArea, 256);
        sash.setLayoutData((Object)new GridData(4, 4, true, true));
        this.styleSelectionPanel = new Composite((Composite)sash, 0);
        GridData data = new GridData(1, 4, false, true);
        data.widthHint = 250;
        this.styleSelectionPanel.setLayoutData((Object)data);
        this.styleSelectionPanel.setLayout((Layout)new GridLayout(1, true));
        this.styleEditionPanel = new Composite((Composite)sash, 0);
        this.styleEditionPanel.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(1, true);
        this.styleEditionPanel.setLayout((Layout)layout);
        sash.setWeights(new int[]{2, 5});
        return this.styleEditionPanel;
    }

    protected void createStyleSelectionPanel() {
        TreeViewer viewer = new TreeViewer(this.styleSelectionPanel, 2048);
        viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        viewer.setContentProvider((IContentProvider)new ExistingStyleContentProvider(this.contextView));
        viewer.setLabelProvider((IBaseLabelProvider)new StylesheetLabelProvider());
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        viewer.setInput(new Object());
        this.styleSelectionPanel.layout();
        this.styleSelectionPanel.getParent().layout();
    }

    protected stylesheet getStylesheet() {
        if (this.ruleset != null) {
            return (stylesheet)this.ruleset.eContainer();
        }
        return null;
    }

    public ruleset getSelectedRuleset() {
        return this.ruleset;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        selection.isEmpty();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sSelection = (IStructuredSelection)selection;
            Object selectedElement = sSelection.getFirstElement();
            if (selectedElement instanceof ruleset) {
                this.handleSelectionChanged((ruleset)selectedElement);
            } else {
                this.ruleset = null;
            }
        }
        this.updateButtons();
    }

    protected void handleSelectionChanged(ruleset selectedRuleset) {
        this.ruleset = selectedRuleset;
        for (AttributeSelector attribute : this.conditions.keySet()) {
            this.conditions.put(attribute, false);
        }
        for (css_declaration declaration : this.declarations.keySet()) {
            this.declarations.put(declaration, false);
        }
        this.diagramRestriction = false;
        this.useSelectorName = false;
        this.cssClass = null;
        for (selector selector2 : selectedRuleset.getSelectors()) {
            this.handleSelector(selector2);
        }
        this.handleDeclarations((List<css_declaration>)selectedRuleset.getDeclarations());
        this.updateContents();
        this.updateSelectorLabel();
    }

    protected void handleDeclarations(List<css_declaration> declarations) {
        block0: for (css_declaration declaration : declarations) {
            for (css_declaration currentDeclaration : this.declarations.keySet()) {
                if (!this.equals(currentDeclaration.getProperty(), declaration.getProperty())) continue;
                this.declarations.put(currentDeclaration, true);
                continue block0;
            }
        }
    }

    protected void handleSelector(simple_selector selector2) {
        if (DiagramTypeHelper.getDiagramType(this.contextView.getDiagram()).equals(this.getElementName(selector2))) {
            this.diagramRestriction = true;
        }
        if (this.contextView.getElement().eClass().getName().equals(this.getElementName(selector2))) {
            this.useSelectorName = true;
        }
        block0: for (CssSelector condition : selector2.getSubSelectors()) {
            if (condition instanceof AttributeSelector) {
                AttributeSelector existingAttribute = (AttributeSelector)condition;
                for (AttributeSelector selectedAttribute : this.conditions.keySet()) {
                    if (!existingAttribute.getName().equals(selectedAttribute.getName())) continue;
                    this.conditions.put(selectedAttribute, true);
                    continue block0;
                }
                continue;
            }
            if (!(condition instanceof ClassSelector)) continue;
            this.cssClass = ((ClassSelector)condition).getName();
        }
    }

    protected void updateContents() {
        this.disposeContents(this.conditionsContainer);
        this.createConditions(this.conditionsContainer);
        this.disposeContents(this.declarationsContainer);
        this.createDeclarations(this.declarationsContainer);
        this.conditionsContainer.layout();
        this.declarationsContainer.layout();
        this.tabFolder.layout();
        this.getDialogArea().layout();
    }

    protected void disposeContents(Composite composite) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
    }

    protected void handleSelector(selector selector2) {
        if (selector2 == null) {
            return;
        }
        for (simple_selector simpleSelector : selector2.getSimpleselectors()) {
            this.handleSelector(simpleSelector);
        }
        this.handleSelector(selector2.getSelector());
    }

    @Override
    protected boolean isValid() {
        boolean result = true;
        if (this.ruleset == null) {
            this.setError("You must select an existing Style");
            result = false;
        }
        return super.isValid() && result;
    }
}

