/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.CompositeName;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.sessions.Connector;
import org.eclipse.persistence.sessions.Session;

public class JNDIConnector
implements Connector {
    protected DataSource dataSource;
    protected Context context;
    protected String name;
    protected boolean isCallbackRegistered;
    public static final int UNDEFINED_LOOKUP = -1;
    public static final int STRING_LOOKUP = 1;
    public static final int COMPOSITE_NAME_LOOKUP = 2;
    public static final int COMPOUND_NAME_LOOKUP = 3;
    @Deprecated
    protected int lookupType = -1;

    public JNDIConnector() {
    }

    public JNDIConnector(Context context, String name) throws ValidationException {
        this(name);
        this.context = context;
    }

    public JNDIConnector(String name) {
        this.name = name;
    }

    public JNDIConnector(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            throw new InternalError("Clone failed");
        }
    }

    @Override
    public Connection connect(Properties properties, Session session) throws DatabaseException, ValidationException {
        String user = properties.getProperty("user");
        DataSource dataSource = this.getDataSource();
        if (dataSource == null) {
            try {
                int type = this.lookupType;
                if (this.lookupType == -1) {
                    type = session.getServerPlatform().getJNDIConnectorLookupType();
                }
                dataSource = type == 1 ? (DataSource)this.getContext().lookup(this.getName()) : (type == 2 ? (DataSource)this.getContext().lookup(new CompositeName(this.name)) : (DataSource)this.getContext().lookup(new CompoundName(this.name, new Properties())));
                this.setDataSource(dataSource);
            }
            catch (NamingException exception) {
                throw ValidationException.cannotAcquireDataSource(this.getName(), exception);
            }
        }
        if (!this.isCallbackRegistered && session.getPlatform().hasPartitioningCallback()) {
            session.getPlatform().getPartitioningCallback().register(dataSource, session);
            this.isCallbackRegistered = true;
        }
        try {
            if (user == null || user.length() == 0) {
                return dataSource.getConnection();
            }
            Object passwordObject = properties.get("password");
            String password = null;
            if (passwordObject instanceof char[]) {
                password = new String((char[])passwordObject);
            } else if (passwordObject instanceof String) {
                password = (String)passwordObject;
            }
            return dataSource.getConnection(user, password);
        }
        catch (SQLException exception) {
            throw DatabaseException.sqlException(exception, true);
        }
    }

    public Context getContext() {
        if (this.context == null) {
            try {
                this.context = new InitialContext();
            }
            catch (NamingException namingException) {}
        }
        return this.context;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getConnectionDetails() {
        return this.getName();
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setName(String name) throws ValidationException {
        this.name = name;
    }

    public void setLookupType(int lookupType) {
        this.lookupType = lookupType;
    }

    public int getLookupType() {
        return this.lookupType;
    }

    public String toString() {
        return String.valueOf(Helper.getShortClassName(this.getClass())) + ToStringLocalization.buildMessage("datasource_name", null) + "=>" + this.getName();
    }

    @Override
    public void toString(PrintWriter writer) {
        writer.print(String.valueOf(ToStringLocalization.buildMessage("connector", null)) + "=>" + Helper.getShortClassName(this.getClass()));
        writer.print(" ");
        writer.println(String.valueOf(ToStringLocalization.buildMessage("datasource_name", null)) + "=>" + this.getName());
    }
}

