/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pmf.pim.util;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.pmf.emf.EMFDataModelManager;
import org.eclipse.pmf.emf.EMFProperty;
import org.eclipse.pmf.emf.EMFType;
import org.eclipse.pmf.emf.PEMFFactory;
import org.eclipse.pmf.pim.Application;
import org.eclipse.pmf.pim.DataElement;
import org.eclipse.pmf.pim.DataForm;
import org.eclipse.pmf.pim.DataFormFolder;
import org.eclipse.pmf.pim.DataInheritance;
import org.eclipse.pmf.pim.ElementalDataForm;
import org.eclipse.pmf.pim.Library;
import org.eclipse.pmf.pim.PMFFactory;
import org.eclipse.pmf.pim.PMFPackage;
import org.eclipse.pmf.pim.data.DataFactory;
import org.eclipse.pmf.pim.data.DataModelManager;
import org.eclipse.pmf.pim.data.DataProperty;
import org.eclipse.pmf.pim.data.DataType;
import org.eclipse.pmf.pim.data.GenericType;
import org.eclipse.pmf.pim.data.TypeParameter;
import org.eclipse.pmf.pim.databinding.DataBinding;
import org.eclipse.pmf.pim.databinding.DataBindingPath;

public class PMFUtil {
    public static Resource createLibraryResource(IFile modelFile, String name, String econding, IProgressMonitor progressMonitor) throws IOException {
        EClass eClass = PMFPackage.eINSTANCE.getLibrary();
        Library rootObject = (Library)PMFFactory.eINSTANCE.create(eClass);
        rootObject.setName(name);
        return PMFUtil.createResource(modelFile, rootObject, econding, progressMonitor);
    }

    public static Resource createApplicationResource(IFile modelFile, String name, String econding, IProgressMonitor progressMonitor) throws IOException {
        EClass eClass = PMFPackage.eINSTANCE.getApplication();
        Application rootObject = (Application)PMFFactory.eINSTANCE.create(eClass);
        rootObject.setName(name);
        return PMFUtil.createResource(modelFile, rootObject, econding, progressMonitor);
    }

    public static Resource createResource(IFile modelFile, EObject rootObject, String econding, IProgressMonitor progressMonitor) throws IOException {
        try {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
            Resource resource = resourceSet.createResource(fileURI);
            resource.getContents().add((Object)rootObject);
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("ENCODING", econding);
            resource.save(options);
            Resource resource2 = resource;
            return resource2;
        }
        finally {
            if (progressMonitor != null) {
                progressMonitor.done();
            }
        }
    }

    public static DataForm getResolvedDataForm(DataInheritance dataInheritance) {
        DataFormFolder folder;
        Application application;
        DataForm dataForm = dataInheritance.getDataForm();
        if (dataForm == null && (application = PMFUtil.getApplication(dataInheritance)) != null && (folder = (DataFormFolder)application.getDataFormFolders().get((Object)dataInheritance.getDataType())) != null) {
            dataForm = folder.getDefaultDataForm();
        }
        return dataForm;
    }

    public static Collection<DataForm> getAllPossibleDataForms(DataType dataType) {
        Application application = PMFUtil.getApplication(dataType);
        if (application != null) {
            DataFormFolder folder = (DataFormFolder)application.getDataFormFolders().get((Object)dataType);
            return folder.getDataForms();
        }
        return Collections.EMPTY_LIST;
    }

    public static EMFType mapEMFType(EMFDataModelManager dataModelManager, EClassifier classifier) {
        EMap<EClassifier, EMFType> map = dataModelManager.getTypeMap();
        EMFType type = (EMFType)map.get((Object)classifier);
        if (type != null) {
            return type;
        }
        type = PEMFFactory.eINSTANCE.createEMFType();
        type.setContent(classifier);
        type.setName(classifier.getName());
        if (classifier.getInstanceClass() != null) {
            type.setId(classifier.getInstanceClass().getName());
        }
        map.put((Object)classifier, (Object)type);
        if (classifier instanceof EEnum) {
            type.setEnum(true);
        }
        if (classifier instanceof EClass) {
            EClass eClass = (EClass)classifier;
            for (EClass superType : eClass.getESuperTypes()) {
                EMFType emfType = PMFUtil.mapEMFType(dataModelManager, (EClassifier)superType);
                if (emfType == null) continue;
                type.getSuperTypes().add((Object)emfType);
            }
            HashMap<ETypeParameter, TypeParameter> typeParameterMap = new HashMap<ETypeParameter, TypeParameter>();
            for (ETypeParameter parameter : eClass.getETypeParameters()) {
                TypeParameter typeParameter = PMFUtil.mapEMFTypeParameter(dataModelManager, typeParameterMap, parameter);
                type.getTypeParameters().add((Object)typeParameter);
                typeParameterMap.put(parameter, typeParameter);
            }
            for (EGenericType emfGenericType : eClass.getEGenericSuperTypes()) {
                GenericType pmfGenericType = PMFUtil.mapEMFGenericType(dataModelManager, typeParameterMap, emfGenericType);
                type.getGenericSuperTypes().add((Object)pmfGenericType);
            }
            for (EStructuralFeature structuralFeature : eClass.getEStructuralFeatures()) {
                EMFProperty emfProperty = PEMFFactory.eINSTANCE.createEMFProperty();
                emfProperty.setName(structuralFeature.getName());
                emfProperty.setContent(structuralFeature);
                type.getProperties().add((Object)emfProperty);
                EClassifier featureType = structuralFeature.getEType();
                EMFType emfType = PMFUtil.mapEMFType(dataModelManager, featureType);
                emfProperty.setType(emfType);
                EGenericType emfGenericType = structuralFeature.getEGenericType();
                if (emfGenericType == null) continue;
                GenericType lowerBound = PMFUtil.mapEMFGenericType(dataModelManager, typeParameterMap, emfGenericType);
                emfProperty.setGenericType(lowerBound);
            }
        }
        return type;
    }

    public static TypeParameter mapEMFTypeParameter(EMFDataModelManager dataModelManager, HashMap<ETypeParameter, TypeParameter> typeParameterMap, ETypeParameter parameter) {
        String name = parameter.getName();
        TypeParameter typeParameter = DataFactory.eINSTANCE.createTypeParameter();
        typeParameter.setName(name);
        for (EGenericType emfGenericType : parameter.getEBounds()) {
            GenericType pmfGenericType = PMFUtil.mapEMFGenericType(dataModelManager, typeParameterMap, emfGenericType);
            typeParameter.getBounds().add((Object)pmfGenericType);
        }
        return typeParameter;
    }

    public static GenericType mapEMFGenericType(EMFDataModelManager dataModelManager, HashMap<ETypeParameter, TypeParameter> typeParameterMap, EGenericType genericType) {
        ETypeParameter parameter;
        EGenericType emfLowerBound;
        EGenericType emfUpperBound;
        GenericType pmfGenericType = DataFactory.eINSTANCE.createGenericType();
        EClassifier eClassifier = genericType.getEClassifier();
        if (eClassifier != null) {
            pmfGenericType.setType(PMFUtil.mapEMFType(dataModelManager, eClassifier));
        }
        if ((emfUpperBound = genericType.getEUpperBound()) != null) {
            GenericType upperBound = PMFUtil.mapEMFGenericType(dataModelManager, typeParameterMap, emfUpperBound);
            pmfGenericType.setUpperBound(upperBound);
        }
        if ((emfLowerBound = genericType.getELowerBound()) != null) {
            GenericType lowerBound = PMFUtil.mapEMFGenericType(dataModelManager, typeParameterMap, emfLowerBound);
            pmfGenericType.setLowerBound(lowerBound);
        }
        if ((parameter = genericType.getETypeParameter()) != null) {
            TypeParameter typeParameter = typeParameterMap.get(parameter);
            pmfGenericType.setTypeParameter(typeParameter);
        }
        for (EGenericType emfGenericType : genericType.getETypeArguments()) {
            GenericType pmfArgumentGenericType = PMFUtil.mapEMFGenericType(dataModelManager, typeParameterMap, emfGenericType);
            pmfGenericType.getTypeArguments().add((Object)pmfArgumentGenericType);
        }
        return pmfGenericType;
    }

    public static void applicationInitialize(Application application) {
        EMFDataModelManager dataModelManager = PMFUtil.dataModelManager(application);
    }

    public static EMFDataModelManager dataModelManager(Application application) {
        EMFDataModelManager dataModelManager = null;
        for (DataModelManager manager : application.getDataModelManagers()) {
            if (!manager.isTargetFor((EObject)EcorePackage.eINSTANCE.getEClass()) || !(manager instanceof EMFDataModelManager)) continue;
            dataModelManager = (EMFDataModelManager)manager;
            break;
        }
        if (dataModelManager == null) {
            dataModelManager = PEMFFactory.eINSTANCE.createEMFDataModelManager();
            application.getDataModelManagers().add((Object)dataModelManager);
        }
        return dataModelManager;
    }

    public static Application getApplication(EObject context) {
        EObject current = context;
        while (current != null && !(current instanceof Application)) {
            current = current.eContainer();
        }
        if (current == null) {
            return PMFUtil.getApplication(context.eResource());
        }
        return (Application)current;
    }

    public static Application getApplication(Resource resource) {
        if (resource != null) {
            TreeIterator iterator = resource.getAllContents();
            while (iterator.hasNext()) {
                EObject element = (EObject)iterator.next();
                if (!(element instanceof Application)) continue;
                return (Application)element;
            }
        }
        return null;
    }

    public static boolean hasRootPropertyItem(ElementalDataForm dataForm, DataProperty property) {
        for (DataElement dataElement : dataForm.getChildren()) {
            DataBinding dataBinding = dataElement.getDataBinding();
            DataBindingPath bindingPath = dataBinding.getPath();
            if (bindingPath.getFeature() != property) continue;
            return true;
        }
        return false;
    }
}

