/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.template;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.Validate;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroup;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.job.RunnableJob;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ICompletionProposalProvider;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ILinkedAsyncProposalListener;

public class LinkedAsyncProposalPositionGroup
extends LinkedProposalPositionGroup
implements ICompletionProposalProvider {
    private final RunnableFuture<LinkedProposalPositionGroup.Proposal[]> m_future;
    private final List<ILinkedAsyncProposalListener> m_listeners;

    public LinkedAsyncProposalPositionGroup(String groupId, RunnableFuture<LinkedProposalPositionGroup.Proposal[]> future) {
        super(groupId);
        this.m_future = (RunnableFuture)Validate.notNull(future);
        this.m_listeners = new ArrayList<ILinkedAsyncProposalListener>();
    }

    @Override
    public synchronized void addListener(ILinkedAsyncProposalListener listener) {
        this.m_listeners.add(listener);
    }

    @Override
    public LinkedProposalPositionGroup.Proposal[] getProposals() {
        try {
            return (LinkedProposalPositionGroup.Proposal[])this.m_future.get(100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | TimeoutException e) {
            return new LinkedProposalPositionGroup.Proposal[]{new LinkedProposalPositionGroup.Proposal("Loading...", null, 10)};
        }
        catch (ExecutionException e) {
            throw new SdkException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireLoaded() {
        ILinkedAsyncProposalListener[] listeners = null;
        LinkedAsyncProposalPositionGroup linkedAsyncProposalPositionGroup = this;
        synchronized (linkedAsyncProposalPositionGroup) {
            listeners = this.m_listeners.toArray(new ILinkedAsyncProposalListener[this.m_listeners.size()]);
        }
        ILinkedAsyncProposalListener[] iLinkedAsyncProposalListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            ILinkedAsyncProposalListener listener = iLinkedAsyncProposalListenerArray[n2];
            listener.loaded();
            ++n2;
        }
    }

    @Override
    public void load() {
        final RunnableJob job = new RunnableJob("Load template proposals", this.m_future);
        job.setUser(false);
        job.setSystem(true);
        job.setPriority(10);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                job.removeJobChangeListener((IJobChangeListener)this);
                IStatus result = event.getResult();
                if (result.isOK()) {
                    LinkedAsyncProposalPositionGroup.this.fireLoaded();
                } else if (result.getSeverity() != 8) {
                    SdkLog.error((String)result.getMessage(), (Object[])new Object[]{result.getException()});
                }
            }
        });
        job.schedule();
    }
}

