/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.scout.sdk.core.model.api.IFileLocator;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.model.spi.internal.ClasspathEntry;
import org.eclipse.scout.sdk.core.model.spi.internal.JavaEnvironmentWithJdt;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.internal.S2ESdkActivator;
import org.eclipse.scout.sdk.s2e.internal.WorkingCopyManager;
import org.eclipse.scout.sdk.s2e.operation.IWorkingCopyManager;
import org.eclipse.scout.sdk.s2e.trigger.IDerivedResourceManager;

public final class ScoutSdkCore {
    private ScoutSdkCore() {
    }

    public static IDerivedResourceManager getDerivedResourceManager() {
        S2ESdkActivator plugin = S2ESdkActivator.getDefault();
        if (plugin == null) {
            return null;
        }
        return plugin.getDerivedResourceManager();
    }

    public static IWorkingCopyManager createWorkingCopyManager() {
        return new WorkingCopyManager();
    }

    public static IJavaEnvironment createJavaEnvironment(IJavaProject javaProject) {
        Validate.notNull((Object)javaProject);
        return new JavaEnvironmentWithJdt(ScoutSdkCore.createFileLocator(javaProject), ScoutSdkCore.javaHomeOf(javaProject), ScoutSdkCore.getClasspathEntries(javaProject)).wrap();
    }

    private static Path javaHomeOf(IJavaProject javaProject) {
        try {
            File javaInstallLocation;
            IVMInstall vmInstall = JavaRuntime.getVMInstall((IJavaProject)javaProject);
            if (vmInstall != null && (javaInstallLocation = vmInstall.getInstallLocation()) != null) {
                Path javaInstallPath = javaInstallLocation.toPath();
                if (Files.isDirectory(javaInstallPath.resolve("jre/lib"), new LinkOption[0])) {
                    return javaInstallPath.resolve("jre");
                }
                return javaInstallPath;
            }
            SdkLog.info((String)"Unable to find Java home location for project '{}'. Using running Java home as fallback.", (Object[])new Object[]{javaProject.getElementName()});
            return null;
        }
        catch (CoreException e) {
            throw new SdkException((Throwable)e);
        }
    }

    private static IFileLocator createFileLocator(IJavaProject javaProject) {
        final IProject project = javaProject.getProject();
        return new IFileLocator(){

            public File getFile(String path) {
                return project.getFile(path).getRawLocation().toFile();
            }
        };
    }

    private static List<ClasspathEntry> getClasspathEntries(IJavaProject javaProject) {
        try {
            IPackageFragmentRoot[] allPackageFragmentRoots = javaProject.getAllPackageFragmentRoots();
            ArrayList<ClasspathEntry> result = new ArrayList<ClasspathEntry>(allPackageFragmentRoots.length);
            IPackageFragmentRoot[] iPackageFragmentRootArray = allPackageFragmentRoots;
            int n = allPackageFragmentRoots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot cpRoot = iPackageFragmentRootArray[n2];
                String encoding = ScoutSdkCore.getEncoding(cpRoot);
                if (cpRoot.getKind() == 1) {
                    result.add(new ClasspathEntry(cpRoot.getResource().getLocation().toFile().toPath(), 1, encoding));
                } else if (!ScoutSdkCore.isJreContainerElement(cpRoot)) {
                    Path cpLocation = cpRoot.getPath().toFile().toPath();
                    IPath cpSourceLocation = cpRoot.getSourceAttachmentPath();
                    if (cpSourceLocation != null) {
                        result.add(new ClasspathEntry(cpSourceLocation.toFile().toPath(), 1, encoding));
                        result.add(new ClasspathEntry(cpLocation, 2, null));
                    } else {
                        result.add(new ClasspathEntry(cpLocation, 3, encoding));
                    }
                }
                ++n2;
            }
            return result;
        }
        catch (CoreException e) {
            throw new SdkException((Throwable)e);
        }
    }

    private static boolean isJreContainerElement(IPackageFragmentRoot root) throws JavaModelException {
        IClasspathEntry entry = root.getRawClasspathEntry();
        if (entry.getEntryKind() != 5) {
            return false;
        }
        String type = entry.getPath().segment(0);
        return JavaRuntime.JRE_CONTAINER.equals(type);
    }

    private static String getEncoding(IPackageFragmentRoot root) throws CoreException {
        String systemEncoding;
        IContainer c;
        IFile f;
        String charset;
        IResource resource = root.getResource();
        if (resource != null && resource.exists() && (resource instanceof IFile ? ScoutSdkCore.isValidEncoding(charset = (f = (IFile)resource).getCharset(true), root) : resource instanceof IContainer && ScoutSdkCore.isValidEncoding(charset = (c = (IContainer)resource).getDefaultCharset(true), root))) {
            return charset;
        }
        IPreferencesService preferencesService = Platform.getPreferencesService();
        if (preferencesService != null) {
            IScopeContext[] scopeContext = new IScopeContext[]{new ProjectScope(root.getJavaProject().getProject())};
            String encoding = preferencesService.getString("org.eclipse.core.resources", "encoding", null, scopeContext);
            if (ScoutSdkCore.isValidEncoding(encoding, root)) {
                return encoding;
            }
            scopeContext = new IScopeContext[]{InstanceScope.INSTANCE};
            encoding = preferencesService.getString("org.eclipse.core.resources", "encoding", null, scopeContext);
            if (ScoutSdkCore.isValidEncoding(encoding, root)) {
                return encoding;
            }
        }
        if ((systemEncoding = SystemUtils.FILE_ENCODING) != null) {
            return systemEncoding;
        }
        return StandardCharsets.UTF_8.name();
    }

    private static boolean isValidEncoding(String encoding, IPackageFragmentRoot root) {
        if (StringUtils.isNotBlank((CharSequence)encoding)) {
            if (Charset.isSupported(encoding)) {
                return true;
            }
            SdkLog.warning((String)"Charset '{}' of classpath entry '{}' is not supported by this platform. Trying to decode using default charset.", (Object[])new Object[]{encoding, root.getElementName()});
        }
        return false;
    }
}

