/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.core.selection;

import java.util.Arrays;
import org.eclipse.tcf.te.launch.core.selection.interfaces.ISelectionContext;

public abstract class AbstractSelectionContext
implements ISelectionContext {
    protected final Object context;
    protected String type = null;
    private Object[] selections;
    private boolean isPreferred = false;

    public AbstractSelectionContext(Object context, Object[] selections, boolean isPreferred) {
        this.context = context;
        this.selections = selections != null ? selections : new Object[]{};
        this.isPreferred = isPreferred;
    }

    public AbstractSelectionContext(Object context, String type, Object[] selections, boolean isPreferred) {
        this.context = context;
        this.type = type;
        this.selections = selections != null ? selections : new Object[]{};
        this.isPreferred = isPreferred;
    }

    @Override
    public Object getContext() {
        return this.context;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Object[] getSelections() {
        return this.selections;
    }

    @Override
    public void setIsPreferredContext(boolean isPreferred) {
        this.isPreferred = isPreferred;
    }

    @Override
    public boolean isPreferredContext() {
        return this.isPreferred;
    }

    public boolean equals(Object obj) {
        boolean equals = obj instanceof ISelectionContext;
        if (equals) {
            ISelectionContext otherContext = (ISelectionContext)obj;
            equals &= this.type == null && otherContext.getType() == null || this.type != null && this.type.equals(otherContext.getType());
            equals &= this.isPreferred == otherContext.isPreferredContext();
            Object[] otherSelections = otherContext.getSelections();
            equals &= this.selections == null && otherSelections == null || this.selections != null && otherSelections != null;
            int i = 0;
            int length = this.selections != null ? this.selections.length : -1;
            int otherLength = otherSelections != null ? otherSelections.length : -1;
            equals &= length == otherLength;
            while (equals && i < length) {
                equals &= this.selections[i] == null && otherSelections[i] == null || this.selections[i] != null && this.selections[i].equals(otherSelections[i]);
                ++i;
            }
        }
        return equals;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.type != null) {
            hashCode ^= this.type.hashCode() << 8;
        }
        hashCode ^= Boolean.valueOf(this.isPreferred).hashCode();
        if (this.selections != null) {
            hashCode ^= Arrays.hashCode(this.selections);
        }
        return hashCode;
    }

    public String toString() {
        StringBuffer toString = new StringBuffer();
        if (this.type != null) {
            toString.append(this.type);
        }
        return toString.toString();
    }
}

