/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.filesystem;

import java.util.HashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.RLog;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.LogEntry;
import org.eclipse.team.internal.ccvs.core.client.listeners.LogListener;
import org.eclipse.team.internal.ccvs.core.filesystem.LogEntryCache;
import org.eclipse.team.internal.ccvs.core.filesystem.RLogTreeBuilder;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderTree;

public class RemoteLogger {
    static final String DEAD_STATE = "dead";
    private ICVSRemoteFolder remoteFolder;
    private LogEntryCache cache;
    private RLogTreeBuilder treeBuilder;

    public RemoteLogger(ICVSRemoteFolder folder) {
        this.remoteFolder = folder;
    }

    private void getRemoteChildren(CVSTag tag, IProgressMonitor monitor) {
        try (Session session = new Session(this.remoteFolder.getRepository(), this.remoteFolder, false);){
            this.cache = new LogEntryCache();
            LogListener listener = new LogListener(this.cache);
            Command.LocalOption[] localOptions = this.getLocalOptions(tag, null);
            try {
                session.open(Policy.subMonitorFor(monitor, 10));
                RLog rlog = new RLog();
                rlog.execute(session, Command.NO_GLOBAL_OPTIONS, localOptions, new ICVSRemoteResource[]{this.remoteFolder}, (ICommandOutputListener)listener, Policy.subMonitorFor(monitor, 90));
            }
            catch (CVSException cVSException) {}
        }
    }

    public ICVSResource[] fetchChildren(IProgressMonitor monitor) throws CVSException, TeamException {
        return this.fetchTree(monitor).getChildren();
    }

    public HashMap getFolderMap() {
        return this.treeBuilder.getFolderMap();
    }

    public RemoteFolderTree fetchTree(IProgressMonitor monitor) throws CVSException, TeamException {
        try {
            monitor.beginTask(null, 100);
            CVSTag tag = this.remoteFolder.getTag();
            if (tag == null) {
                tag = CVSTag.DEFAULT;
            }
            this.getRemoteChildren(tag, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)70));
            ICVSRemoteFolder project = this.remoteFolder;
            String[] entry = this.cache.getCachedFilePaths();
            this.treeBuilder = new RLogTreeBuilder(project.getRepository(), tag, this.cache);
            int i = 0;
            while (i < entry.length) {
                ILogEntry[] logEntry = this.cache.getLogEntries(entry[i]);
                if (logEntry[0].getState() == null || !logEntry[0].getState().equals(DEAD_STATE)) {
                    Path logPath;
                    ICVSRemoteFile remoteFile = logEntry[0].getRemoteFile();
                    if (tag.getType() == 1 && remoteFile.getRevision().equals("branchRevision")) {
                        this.verifyRevision(tag, logEntry[0], remoteFile);
                    }
                    if ((logPath = new Path(null, remoteFile.getRepositoryRelativePath())).segmentCount() > 0) {
                        String[] pathSegments = logPath.segments();
                        String projectName = project.getName();
                        int index = 0;
                        while (index < pathSegments.length) {
                            if (pathSegments[index].equals(projectName)) break;
                            ++index;
                        }
                        logPath = logPath.removeFirstSegments(index + 1);
                    }
                    this.treeBuilder.newFile((IPath)logPath, remoteFile);
                }
                ++i;
            }
            RemoteFolderTree remoteFolderTree = this.treeBuilder.getTree();
            return remoteFolderTree;
        }
        finally {
            monitor.done();
        }
    }

    protected Command.LocalOption[] getLocalOptions(CVSTag tag1, CVSTag tag2) {
        if (tag1 != null && tag2 != null) {
            return new Command.LocalOption[]{RLog.NO_TAGS, RLog.ONLY_INCLUDE_CHANGES, RLog.makeTagOption(tag1, tag2)};
        }
        if (tag1 != null) {
            if (tag1.getType() == 0 || tag1.getType() == 2) {
                return new Command.LocalOption[]{RLog.NO_TAGS, RLog.ONLY_INCLUDE_CHANGES, RLog.getCurrentTag(tag1)};
            }
            if (tag1.getType() == 3) {
                return new Command.LocalOption[]{RLog.NO_TAGS, RLog.ONLY_INCLUDE_CHANGES, RLog.REVISIONS_ON_DEFAULT_BRANCH, RLog.getCurrentTag(tag1)};
            }
            return new Command.LocalOption[]{RLog.getCurrentTag(tag1)};
        }
        return new Command.LocalOption[]{RLog.NO_TAGS, RLog.ONLY_INCLUDE_CHANGES};
    }

    private void verifyRevision(CVSTag tag, ILogEntry entry, ICVSRemoteFile remoteFile) throws CVSException {
        if (entry instanceof LogEntry) {
            LogEntry logEntry = (LogEntry)entry;
            String[] allBranchRevisions = logEntry.getBranchRevisions();
            CVSTag[] allCVSTags = entry.getTags();
            int i = 0;
            while (i < allCVSTags.length) {
                if (allCVSTags[i].equals(tag)) {
                    ((RemoteFile)remoteFile).setRevision(allBranchRevisions[i]);
                    break;
                }
                ++i;
            }
        }
    }

    public HashMap getLogMap() {
        return this.treeBuilder.getLogMap();
    }
}

