/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.markers;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.tracecompass.internal.tmf.core.markers.MarkerConfigXmlParser;
import org.eclipse.tracecompass.internal.tmf.core.markers.MarkerSet;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;

public class MarkerUtils {
    private static final String MARKER_SET_KEY = "marker.set";
    private static MarkerSet fDefaultMarkerSet = null;

    public static synchronized @Nullable MarkerSet getDefaultMarkerSet() {
        String id = MarkerUtils.getDialogSettings().get(MARKER_SET_KEY);
        if (id == null) {
            fDefaultMarkerSet = null;
        } else if (fDefaultMarkerSet == null || !fDefaultMarkerSet.getId().equals(id)) {
            for (MarkerSet markerSet : MarkerConfigXmlParser.getMarkerSets()) {
                if (!markerSet.getId().equals(id)) continue;
                fDefaultMarkerSet = markerSet;
            }
        }
        return fDefaultMarkerSet;
    }

    public static synchronized void setDefaultMarkerSet(@Nullable MarkerSet markerSet) {
        fDefaultMarkerSet = markerSet;
        String id = markerSet == null ? null : markerSet.getId();
        MarkerUtils.getDialogSettings().put(MARKER_SET_KEY, id);
    }

    private static IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings dialogSettings = settings.getSection(MarkerUtils.class.getName());
        if (dialogSettings == null) {
            dialogSettings = settings.addNewSection(MarkerUtils.class.getName());
        }
        return dialogSettings;
    }
}

