/*
 * Copyright (c) 2016 Manumitting Technologies Inc and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Manumitting Technologies Inc - initial API and implementation
 */
package org.eclipse.userstorage.tests;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotEquals;

import org.eclipse.userstorage.internal.util.AES;

import org.junit.Test;

import java.security.GeneralSecurityException;

/**
 * Tests for the {@link AES} class.
 */
public class AESTests
{
  @Test
  public void testAES() throws GeneralSecurityException
  {
    char[] password = "this is a test".toCharArray();
    String text = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    for (int i = 1; i < text.length(); i++)
    {
      String source = text.substring(0, i);
      String encryptedForm = AES.encrypt(source, password);
      assertNotEquals("No apparent encryption+encoding", source, encryptedForm);
      String decryptedForm = AES.decrypt(encryptedForm, password);
      assertEquals("Decrypted form is different", source, decryptedForm);
    }

  }
}
