/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.base.itc.alg.incscc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.viatra.query.runtime.base.itc.alg.counting.CountingAlg;
import org.eclipse.viatra.query.runtime.base.itc.alg.dred.DRedTcRelation;
import org.eclipse.viatra.query.runtime.base.itc.alg.incscc.CollectionHelper;
import org.eclipse.viatra.query.runtime.base.itc.alg.incscc.CountingListener;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.DFSPathFinder;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.GraphHelper;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.IGraphPathFinder;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.Tuple;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.bfs.BFS;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.scc.SCC;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.scc.SCCResult;
import org.eclipse.viatra.query.runtime.base.itc.graphimpl.Graph;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IBiDirectionalGraphDataSource;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IBiDirectionalWrapper;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IGraphDataSource;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IGraphObserver;
import org.eclipse.viatra.query.runtime.base.itc.igraph.ITcDataSource;
import org.eclipse.viatra.query.runtime.base.itc.igraph.ITcObserver;
import org.eclipse.viatra.query.runtime.matchers.algorithms.UnionFind;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.matchers.util.IMemoryView;

public class IncSCCAlg<V>
implements IGraphObserver<V>,
ITcDataSource<V> {
    public UnionFind<V> sccs;
    public IBiDirectionalGraphDataSource<V> gds;
    private CountingAlg<V> counting;
    private Graph<V> reducedGraph;
    private IBiDirectionalGraphDataSource<V> reducedGraphIndexer;
    private List<ITcObserver<V>> observers;
    private CountingListener<V> countingListener;

    public IncSCCAlg(IGraphDataSource<V> graphDataSource) {
        this.gds = graphDataSource instanceof IBiDirectionalGraphDataSource ? (IBiDirectionalGraphDataSource)graphDataSource : new IBiDirectionalWrapper<V>(graphDataSource);
        this.observers = CollectionsFactory.createObserverList();
        this.sccs = new UnionFind();
        this.reducedGraph = new Graph();
        this.reducedGraphIndexer = new IBiDirectionalWrapper<V>(this.reducedGraph);
        this.countingListener = new CountingListener(this);
        this.initalizeInternalDataStructures();
        this.gds.attachObserver(this);
    }

    private void initalizeInternalDataStructures() {
        SCCResult<V> _sccres = SCC.computeSCC(this.gds);
        Set<Set<V>> _sccs = _sccres.getSccs();
        for (Set<V> _set : _sccs) {
            this.sccs.makeSet(_set);
        }
        for (Object n : this.sccs.getPartitionHeads()) {
            this.reducedGraph.insertNode(n);
        }
        for (Object source : this.gds.getAllNodes()) {
            IMemoryView<Object> targetNodes = this.gds.getTargetNodes(source);
            for (Map.Entry entry : targetNodes.entriesWithMultiplicities()) {
                int i = 0;
                while (i < (Integer)entry.getValue()) {
                    Object targetRoot;
                    Object target = entry.getKey();
                    Object sourceRoot = this.sccs.find(source);
                    if (!sourceRoot.equals(targetRoot = this.sccs.find(target))) {
                        this.reducedGraph.insertEdge(sourceRoot, targetRoot);
                    }
                    ++i;
                }
            }
        }
        this.counting = new CountingAlg<V>(this.reducedGraph);
    }

    @Override
    public void edgeInserted(V source, V target) {
        Object targetRoot;
        Object sourceRoot = this.sccs.find(source);
        if (!sourceRoot.equals(targetRoot = this.sccs.find(target))) {
            if (this.counting.isReachable(targetRoot, sourceRoot)) {
                Collection<Object> targetSCCs;
                Collection<Object> sourceSCCs;
                Set<Object> predecessorRoots = this.counting.getAllReachableSources(sourceRoot);
                Set<Object> successorRoots = this.counting.getAllReachableTargets(targetRoot);
                Set<Object> isectRoots = CollectionHelper.intersectionMutable(predecessorRoots, successorRoots);
                isectRoots.add(sourceRoot);
                isectRoots.add(targetRoot);
                if (this.observers.size() > 0) {
                    sourceSCCs = IncSCCAlg.createSetNullTolerant(predecessorRoots);
                    sourceSCCs.add(sourceRoot);
                    targetSCCs = IncSCCAlg.createSetNullTolerant(successorRoots);
                    targetSCCs.add(targetRoot);
                    for (Object sourceSCC : sourceSCCs) {
                        for (Object e : targetSCCs) {
                            boolean needsNotification;
                            if (this.counting.isReachable(sourceSCC, e)) continue;
                            boolean bl = needsNotification = sourceSCC.equals(e) && this.sccs.getPartition(sourceSCC).size() == 1 && GraphHelper.getEdgeCount(this.sccs.getPartition(sourceSCC).iterator().next(), this.gds) == 0 || !sourceSCC.equals(e);
                            if (!needsNotification) continue;
                            this.notifyTcObservers((V)this.sccs.getPartition(sourceSCC), (V)this.sccs.getPartition(e), Direction.INSERT);
                        }
                    }
                }
                sourceSCCs = new ArrayList();
                targetSCCs = new ArrayList();
                for (Object r : isectRoots) {
                    List<Object> list = this.getSourceSCCsOfSCC(r);
                    List<Object> list2 = this.getTargetSCCsOfSCC(r);
                    for (Object sourceSCC : list) {
                        if (sourceSCC.equals(r)) continue;
                        this.reducedGraph.deleteEdgeIfExists(sourceSCC, r);
                    }
                    for (Object targetSCC : list2) {
                        if (isectRoots.contains(targetSCC) || r.equals(targetSCC)) continue;
                        this.reducedGraph.deleteEdgeIfExists(r, targetSCC);
                    }
                    sourceSCCs.addAll(list);
                    targetSCCs.addAll(list2);
                }
                for (Object r : isectRoots) {
                    this.reducedGraph.deleteNode(r);
                }
                Iterator<Object> iterator = isectRoots.iterator();
                Object newRoot = iterator.next();
                while (iterator.hasNext()) {
                    newRoot = this.sccs.union(newRoot, iterator.next());
                }
                this.reducedGraph.insertNode(newRoot);
                Set set = this.sccs.getPartition(newRoot);
                for (Object e : sourceSCCs) {
                    if (set.contains(e) || e.equals(newRoot)) continue;
                    this.reducedGraph.insertEdge(e, newRoot);
                }
                for (Object e : targetSCCs) {
                    if (set.contains(e) || e.equals(newRoot)) continue;
                    this.reducedGraph.insertEdge(newRoot, e);
                }
            } else {
                if (this.observers.size() > 0 && GraphHelper.getEdgeCount(source, target, this.gds) == 1) {
                    this.counting.attachObserver(this.countingListener);
                }
                this.reducedGraph.insertEdge(sourceRoot, targetRoot);
                this.counting.detachObserver(this.countingListener);
            }
        } else if (this.observers.size() > 0 && this.sccs.getPartition(sourceRoot).size() == 1 && GraphHelper.getEdgeCount(source, target, this.gds) == 1) {
            this.notifyTcObservers(source, source, Direction.INSERT);
        }
    }

    @Override
    public void edgeDeleted(V source, V target) {
        Object targetRoot;
        Object sourceRoot = this.sccs.find(source);
        if (!sourceRoot.equals(targetRoot = this.sccs.find(target))) {
            if (this.observers.size() > 0 && GraphHelper.getEdgeCount(source, target, this.gds) == 0) {
                this.counting.attachObserver(this.countingListener);
            }
            this.reducedGraph.deleteEdgeIfExists(sourceRoot, targetRoot);
            this.counting.detachObserver(this.countingListener);
        } else {
            Graph<V> g = GraphHelper.getSubGraph(this.sccs.getPartition(sourceRoot), this.gds);
            if (!BFS.isReachable(source, target, g)) {
                int i;
                Map reachableSources = CollectionsFactory.createMap();
                for (Map.Entry entry : this.reducedGraphIndexer.getSourceNodes(sourceRoot).entriesWithMultiplicities()) {
                    reachableSources.put(entry.getKey(), (Integer)entry.getValue());
                }
                Map reachableTargets = CollectionsFactory.createMap();
                for (Map.Entry entry : this.reducedGraphIndexer.getTargetNodes(sourceRoot).entriesWithMultiplicities()) {
                    reachableTargets.put(entry.getKey(), (Integer)entry.getValue());
                }
                SCCResult<V> _newSccs = SCC.computeSCC(g);
                for (Map.Entry entry : reachableSources.entrySet()) {
                    Object s = entry.getKey();
                    i = 0;
                    while (i < (Integer)entry.getValue()) {
                        this.reducedGraph.deleteEdgeIfExists(s, sourceRoot);
                        ++i;
                    }
                }
                for (Map.Entry entry : reachableTargets.entrySet()) {
                    Object t = entry.getKey();
                    i = 0;
                    while (i < (Integer)entry.getValue()) {
                        this.reducedGraph.deleteEdgeIfExists(sourceRoot, t);
                        ++i;
                    }
                }
                this.sccs.deleteSet(sourceRoot);
                this.reducedGraph.deleteNode(sourceRoot);
                Set<Set<V>> newSCCs = _newSccs.getSccs();
                Set newSCCRoots = CollectionsFactory.createSet();
                for (Set<V> newSCC : newSCCs) {
                    Object newRoot = this.sccs.makeSet(newSCC);
                    this.reducedGraph.insertNode(newRoot);
                    newSCCRoots.add(newRoot);
                }
                for (Object newSCCRoot : newSCCRoots) {
                    List<Object> sourceSCCsOfSCC = this.getSourceSCCsOfSCC(newSCCRoot);
                    List<Object> targetSCCsOfSCC = this.getTargetSCCsOfSCC(newSCCRoot);
                    for (Object sourceSCC : sourceSCCsOfSCC) {
                        if (sourceSCC.equals(newSCCRoot)) continue;
                        this.reducedGraph.insertEdge(this.sccs.find(sourceSCC), newSCCRoot);
                    }
                    for (Object targetSCC : targetSCCsOfSCC) {
                        if (newSCCRoots.contains(targetSCC) || targetSCC.equals(newSCCRoot)) continue;
                        this.reducedGraph.insertEdge(newSCCRoot, targetSCC);
                    }
                }
                if (this.observers.size() > 0) {
                    Object newSourceRoot = this.sccs.find(source);
                    Object newTargetRoot = this.sccs.find(target);
                    Set<Object> sourceSCCs = IncSCCAlg.createSetNullTolerant(this.counting.getAllReachableSources(newSourceRoot));
                    sourceSCCs.add(newSourceRoot);
                    Set<Object> targetSCCs = IncSCCAlg.createSetNullTolerant(this.counting.getAllReachableTargets(newTargetRoot));
                    targetSCCs.add(newTargetRoot);
                    for (Object sourceSCC : sourceSCCs) {
                        for (Object targetSCC : targetSCCs) {
                            boolean needsNotification;
                            if (this.counting.isReachable(sourceSCC, targetSCC)) continue;
                            boolean bl = needsNotification = sourceSCC.equals(targetSCC) && this.sccs.getPartition(sourceSCC).size() == 1 && GraphHelper.getEdgeCount(this.sccs.getPartition(sourceSCC).iterator().next(), this.gds) == 0 || !sourceSCC.equals(targetSCC);
                            if (!needsNotification) continue;
                            this.notifyTcObservers((V)this.sccs.getPartition(sourceSCC), (V)this.sccs.getPartition(targetSCC), Direction.DELETE);
                        }
                    }
                }
            } else if (this.observers.size() > 0 && this.sccs.getPartition(sourceRoot).size() == 1 && GraphHelper.getEdgeCount(source, target, this.gds) == 0) {
                this.notifyTcObservers(source, source, Direction.DELETE);
            }
        }
    }

    @Override
    public void nodeInserted(V n) {
        this.sccs.makeSet(n);
        this.reducedGraph.insertNode(n);
    }

    @Override
    public void nodeDeleted(V n) {
        int i;
        IMemoryView<V> sources = this.gds.getSourceNodes(n);
        IMemoryView<V> targets = this.gds.getTargetNodes(n);
        for (Map.Entry entry : sources.entriesWithMultiplicities()) {
            i = 0;
            while (i < (Integer)entry.getValue()) {
                Object source = entry.getKey();
                this.edgeDeleted(source, n);
                ++i;
            }
        }
        for (Map.Entry entry : targets.entriesWithMultiplicities()) {
            i = 0;
            while (i < (Integer)entry.getValue()) {
                Object target = entry.getKey();
                this.edgeDeleted(n, target);
                ++i;
            }
        }
        this.sccs.deleteSet(n);
    }

    @Override
    public void attachObserver(ITcObserver<V> to) {
        this.observers.add(to);
    }

    @Override
    public void detachObserver(ITcObserver<V> to) {
        this.observers.remove(to);
    }

    @Override
    public Set<V> getAllReachableTargets(V source) {
        Set<Object> rootSet;
        Object sourceRoot = this.sccs.find(source);
        Set containedNodes = this.sccs.getPartition(sourceRoot);
        Set targets = CollectionsFactory.createSet();
        if (containedNodes.size() > 1 || GraphHelper.getEdgeCount(source, this.gds) == 1) {
            targets.addAll(containedNodes);
        }
        if ((rootSet = this.counting.getAllReachableTargets(sourceRoot)) != null) {
            for (Object _root : rootSet) {
                targets.addAll(this.sccs.getPartition(_root));
            }
        }
        return targets;
    }

    @Override
    public Set<V> getAllReachableSources(V target) {
        Set<Object> rootSet;
        Object targetRoot = this.sccs.find(target);
        Set containedNodes = this.sccs.getPartition(targetRoot);
        Set sources = CollectionsFactory.createSet();
        if (containedNodes.size() > 1 || GraphHelper.getEdgeCount(target, this.gds) == 1) {
            sources.addAll(containedNodes);
        }
        if ((rootSet = this.counting.getAllReachableSources(targetRoot)) != null) {
            for (Object _root : rootSet) {
                sources.addAll(this.sccs.getPartition(_root));
            }
        }
        return sources;
    }

    @Override
    public boolean isReachable(V source, V target) {
        Object targetRoot;
        Object sourceRoot = this.sccs.find(source);
        if (sourceRoot.equals(targetRoot = this.sccs.find(target))) {
            return true;
        }
        return this.counting.isReachable(sourceRoot, targetRoot);
    }

    public List<V> getReachabilityPath(V source, V target) {
        if (!this.isReachable(source, target)) {
            return null;
        }
        Set<V> sccsInSubGraph = CollectionHelper.intersectionMutable(this.counting.getAllReachableTargets(source), this.counting.getAllReachableSources(target));
        sccsInSubGraph.add(this.sccs.find(source));
        sccsInSubGraph.add(this.sccs.find(target));
        Set nodesInSubGraph = CollectionsFactory.createSet();
        for (V sccRoot : sccsInSubGraph) {
            nodesInSubGraph.addAll(this.sccs.getPartition(sccRoot));
        }
        return GraphHelper.constructPath(source, target, nodesInSubGraph, this.gds);
    }

    public boolean checkTcRelation(DRedTcRelation<V> tc) {
        for (V s : tc.getTupleStarts()) {
            for (V t : tc.getTupleEnds(s)) {
                if (this.isReachable(s, t)) continue;
                return false;
            }
        }
        for (V root : this.counting.getTcRelation().getTupleStarts()) {
            for (V end : this.counting.getTcRelation().getTupleEnds(root)) {
                for (Object s : this.sccs.getPartition(root)) {
                    for (Object t : this.sccs.getPartition(end)) {
                        if (tc.containsTuple(s, t)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private List<V> getSourceSCCsOfSCC(V root) {
        ArrayList<Object> sourceSCCs = new ArrayList<Object>();
        for (Object containedNode : this.sccs.getPartition(root)) {
            IMemoryView<V> sourceNodes = this.gds.getSourceNodes(containedNode);
            for (Object source : sourceNodes.distinctValues()) {
                sourceSCCs.add(this.sccs.find(source));
            }
        }
        return sourceSCCs;
    }

    public boolean hasIncomingEdges(V root) {
        for (Object containedNode : this.sccs.getPartition(root)) {
            IMemoryView<V> sourceNodes = this.gds.getSourceNodes(containedNode);
            for (Object source : sourceNodes.distinctValues()) {
                Object otherRoot = this.sccs.find(source);
                if (Objects.equals(root, otherRoot)) continue;
                return true;
            }
        }
        return false;
    }

    private List<V> getTargetSCCsOfSCC(V root) {
        ArrayList<Object> targetSCCs = new ArrayList<Object>();
        for (Object containedNode : this.sccs.getPartition(root)) {
            IMemoryView targetNodes = this.gds.getTargetNodes(containedNode);
            for (Object target : targetNodes.distinctValues()) {
                targetSCCs.add(this.sccs.find(target));
            }
        }
        return targetSCCs;
    }

    public boolean hasOutgoingEdges(V root) {
        for (Object containedNode : this.sccs.getPartition(root)) {
            IMemoryView targetNodes = this.gds.getTargetNodes(containedNode);
            for (Object target : targetNodes.distinctValues()) {
                Object otherRoot = this.sccs.find(target);
                if (Objects.equals(root, otherRoot)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void dispose() {
        this.gds.detachObserver(this);
        this.counting.dispose();
    }

    protected void notifyTcObservers(Set<V> sources, Set<V> targets, Direction direction) {
        for (V s : sources) {
            for (V t : targets) {
                this.notifyTcObservers(s, t, direction);
            }
        }
    }

    private void notifyTcObservers(V source, V target, Direction direction) {
        for (ITcObserver<V> observer : this.observers) {
            if (direction == Direction.INSERT) {
                observer.tupleInserted(source, target);
            }
            if (direction != Direction.DELETE) continue;
            observer.tupleDeleted(source, target);
        }
    }

    public V getRepresentative(V node) {
        return (V)this.sccs.find(node);
    }

    public Set<Tuple<V>> getTcRelation() {
        HashSet<Tuple<V>> resultSet = new HashSet<Tuple<V>>();
        for (Object sourceRoot : this.sccs.getPartitionHeads()) {
            Set<V> reachableTargets;
            Set sources = this.sccs.getPartition(sourceRoot);
            if (sources.size() > 1 || GraphHelper.getEdgeCount(sources.iterator().next(), this.gds) == 1) {
                for (Object source : sources) {
                    for (Object target : sources) {
                        resultSet.add(new Tuple(source, target));
                    }
                }
            }
            if ((reachableTargets = this.counting.getAllReachableTargets(sourceRoot)) == null) continue;
            for (V targetRoot : reachableTargets) {
                for (Object source : sources) {
                    for (Object target : this.sccs.getPartition(targetRoot)) {
                        resultSet.add(new Tuple(source, target));
                    }
                }
            }
        }
        return resultSet;
    }

    public boolean isIsolated(V node) {
        IMemoryView<V> targets = this.gds.getTargetNodes(node);
        IMemoryView<V> sources = this.gds.getSourceNodes(node);
        return targets.isEmpty() && sources.isEmpty();
    }

    @Override
    public IGraphPathFinder<V> getPathFinder() {
        return new DFSPathFinder<V>(this.gds, this);
    }

    public Graph<V> getReducedGraph() {
        return this.reducedGraph;
    }

    private static <V> Set<V> createSetNullTolerant(Set<V> initial) {
        if (initial != null) {
            return CollectionsFactory.createSet(initial);
        }
        return CollectionsFactory.createSet();
    }
}

