/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.util;

import java.util.Iterator;
import java.util.Set;
import java.util.function.BiConsumer;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.impl.map.mutable.primitive.LongIntHashMap;
import org.eclipse.viatra.query.runtime.matchers.util.EclipseCollectionsLongSetMemory;
import org.eclipse.viatra.query.runtime.matchers.util.IMemoryView;
import org.eclipse.viatra.query.runtime.matchers.util.IMultiset;

public class EclipseCollectionsLongMultiset
extends LongIntHashMap
implements IMultiset<Long> {
    @Override
    public boolean addOne(Long value) {
        int oldCount = super.getIfAbsent(value.longValue(), 0);
        super.put(value.longValue(), oldCount + 1);
        return oldCount == 0;
    }

    @Override
    public boolean addSigned(Long value, int count2) {
        boolean becomesZero;
        int oldCount = super.getIfAbsent(value.longValue(), 0);
        int newCount = oldCount + count2;
        boolean bl = becomesZero = newCount == 0;
        if (newCount < 0) {
            throw new IllegalStateException(String.format("Cannot remove %d occurrences of value '%s' as only %d would remain in %s", count2, value, newCount, this));
        }
        if (becomesZero) {
            super.removeKey(value.longValue());
        } else {
            super.put(value.longValue(), newCount);
        }
        return becomesZero || oldCount == 0;
    }

    @Override
    public boolean removeOne(Long value) {
        boolean empty;
        int oldCount = super.getIfAbsent(value.longValue(), 0);
        if (oldCount == 0) {
            throw new IllegalStateException(String.format("Cannot remove value '%s' that is not contained in %s", value, this));
        }
        int rest = oldCount - 1;
        boolean bl = empty = rest == 0;
        if (!empty) {
            super.put(value.longValue(), rest);
        } else {
            super.remove(value.longValue());
        }
        return empty;
    }

    @Override
    public void clearAllOf(Long value) {
        super.remove(value.longValue());
    }

    @Override
    public int getCount(Long value) {
        return super.getIfAbsent(value.longValue(), 0);
    }

    @Override
    public int getCountUnsafe(Object value) {
        return value instanceof Long ? this.getCount((Long)value) : 0;
    }

    @Override
    public boolean containsNonZero(Long value) {
        return super.containsKey(value.longValue());
    }

    @Override
    public boolean containsNonZeroUnsafe(Object value) {
        return value instanceof Long && this.containsNonZero((Long)value);
    }

    @Override
    public Iterator<Long> iterator() {
        return EclipseCollectionsLongSetMemory.iteratorOf((LongIterable)super.keySet());
    }

    @Override
    public boolean addPositive(Long value, int count2) {
        if (count2 < 0) {
            throw new IllegalArgumentException("The count value must be positive!");
        }
        int oldCount = super.getIfAbsent(value.longValue(), 0);
        super.put(value.longValue(), oldCount + count2);
        return oldCount == 0;
    }

    @Override
    public Set<Long> distinctValues() {
        return new EclipseCollectionsLongSetMemory.SetWrapper((LongSet)super.keySet());
    }

    @Override
    public void forEachEntryWithMultiplicities(BiConsumer<Long, Integer> entryConsumer) {
        super.forEachKeyValue(entryConsumer::accept);
    }

    public int hashCode() {
        return IMemoryView.hashCode(this);
    }

    public boolean equals(Object obj) {
        return IMemoryView.equals(this, obj);
    }
}

