/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.single;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.rete.network.Direction;
import org.eclipse.viatra.query.runtime.rete.network.Receiver;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.Mailbox;
import org.eclipse.viatra.query.runtime.rete.single.DiscriminatorBucketNode;
import org.eclipse.viatra.query.runtime.rete.single.SingleInputNode;

public class DiscriminatorDispatcherNode
extends SingleInputNode {
    private int discriminationColumnIndex;
    private Map<Object, DiscriminatorBucketNode> buckets = new HashMap<Object, DiscriminatorBucketNode>();
    private Map<Object, Mailbox> bucketMailboxes = new HashMap<Object, Mailbox>();

    public DiscriminatorDispatcherNode(ReteContainer reteContainer, int discriminationColumnIndex) {
        super(reteContainer);
        this.discriminationColumnIndex = discriminationColumnIndex;
    }

    @Override
    public void update(Direction direction, Tuple updateElement) {
        Object dispatchKey = updateElement.get(this.discriminationColumnIndex);
        Mailbox bucketMailBox = this.bucketMailboxes.get(dispatchKey);
        if (bucketMailBox != null) {
            bucketMailBox.postMessage(direction, updateElement);
        }
    }

    public int getDiscriminationColumnIndex() {
        return this.discriminationColumnIndex;
    }

    @Override
    public void pullInto(Collection<Tuple> collector) {
        this.propagatePullInto(collector);
    }

    public void pullIntoFiltered(Collection<Tuple> collector, Object bucketKey) {
        ArrayList<Tuple> unfiltered = new ArrayList<Tuple>();
        this.propagatePullInto(unfiltered);
        for (Tuple tuple : unfiltered) {
            if (!bucketKey.equals(tuple.get(this.discriminationColumnIndex))) continue;
            collector.add(tuple);
        }
    }

    @Override
    public void appendChild(Receiver receiver) {
        super.appendChild(receiver);
        if (receiver instanceof DiscriminatorBucketNode) {
            DiscriminatorBucketNode bucket = (DiscriminatorBucketNode)receiver;
            Object bucketKey = bucket.getBucketKey();
            DiscriminatorBucketNode old = this.buckets.put(bucketKey, bucket);
            if (old != null) {
                throw new IllegalStateException();
            }
            this.bucketMailboxes.put(bucketKey, bucket.getMailbox());
        }
    }

    @Override
    public void removeChild(Receiver receiver) {
        super.removeChild(receiver);
        if (receiver instanceof DiscriminatorBucketNode) {
            DiscriminatorBucketNode bucket = (DiscriminatorBucketNode)receiver;
            Object bucketKey = bucket.getBucketKey();
            DiscriminatorBucketNode old = this.buckets.remove(bucketKey);
            if (old != bucket) {
                throw new IllegalStateException();
            }
            this.bucketMailboxes.remove(bucketKey);
        }
    }

    @Override
    protected String toStringCore() {
        return String.valueOf(super.toStringCore()) + '<' + this.discriminationColumnIndex + '>';
    }
}

