/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.event.definitions;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.SignalEventDefinition;
import org.eclipse.bpmn2.modeler.core.features.event.definitions.AbstractCreateEventDefinitionFeature;
import org.eclipse.bpmn2.modeler.core.features.event.definitions.AbstractEventDefinitionFeatureContainer;
import org.eclipse.bpmn2.modeler.core.features.event.definitions.DecorationAlgorithm;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.ShapeDecoratorUtil;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public class SignalEventDefinitionContainer
extends AbstractEventDefinitionFeatureContainer {
    public boolean canApplyTo(Object o) {
        return super.canApplyTo(o) && o instanceof SignalEventDefinition;
    }

    public ICreateFeature getCreateFeature(IFeatureProvider fp) {
        return new CreateSignalEventDefinition(fp);
    }

    protected Shape drawForStart(DecorationAlgorithm algorithm, ContainerShape shape) {
        return SignalEventDefinitionContainer.draw(shape);
    }

    protected Shape drawForEnd(DecorationAlgorithm algorithm, ContainerShape shape) {
        return SignalEventDefinitionContainer.drawFilled(shape);
    }

    protected Shape drawForThrow(DecorationAlgorithm algorithm, ContainerShape shape) {
        return SignalEventDefinitionContainer.drawFilled(shape);
    }

    protected Shape drawForCatch(DecorationAlgorithm algorithm, ContainerShape shape) {
        return SignalEventDefinitionContainer.draw(shape);
    }

    protected Shape drawForBoundary(DecorationAlgorithm algorithm, ContainerShape shape) {
        return SignalEventDefinitionContainer.draw(shape);
    }

    public static Shape draw(ContainerShape shape) {
        BaseElement be = (BaseElement)BusinessObjectUtil.getFirstElementOfType((PictogramElement)shape, BaseElement.class, (boolean)true);
        Shape signalShape = Graphiti.getPeService().createShape(shape, false);
        Polygon signal = ShapeDecoratorUtil.createEventSignal((Shape)signalShape);
        StyleUtil.setFillStyle((GraphicsAlgorithm)signal, (StyleUtil.FillStyle)StyleUtil.FillStyle.FILL_STYLE_BACKGROUND);
        StyleUtil.applyStyle((GraphicsAlgorithm)signal, (BaseElement)be);
        return signalShape;
    }

    public static Shape drawFilled(ContainerShape shape) {
        BaseElement be = (BaseElement)BusinessObjectUtil.getFirstElementOfType((PictogramElement)shape, BaseElement.class, (boolean)true);
        Shape signalShape = Graphiti.getPeService().createShape(shape, false);
        Polygon signal = ShapeDecoratorUtil.createEventSignal((Shape)signalShape);
        StyleUtil.setFillStyle((GraphicsAlgorithm)signal, (StyleUtil.FillStyle)StyleUtil.FillStyle.FILL_STYLE_FOREGROUND);
        StyleUtil.applyStyle((GraphicsAlgorithm)signal, (BaseElement)be);
        return signalShape;
    }

    public static class CreateSignalEventDefinition
    extends AbstractCreateEventDefinitionFeature<SignalEventDefinition> {
        public CreateSignalEventDefinition(IFeatureProvider fp) {
            super(fp);
        }

        protected String getStencilImageId() {
            return ImageProvider.IMG_16_SIGNAL;
        }

        public EClass getBusinessObjectClass() {
            return Bpmn2Package.eINSTANCE.getSignalEventDefinition();
        }
    }
}

