/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.editor3x.refactorparticipants;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.e4.tools.emf.editor3x.RefactorModel;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.pde.internal.ui.refactoring.MovedTextFileChange;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

class RefactorParticipantDelegate {
    private static final String E4_MODEL_CHANGES = "Eclipse 4 Application Model Changes";

    RefactorParticipantDelegate() {
    }

    public static CompositeChange createChange(IProgressMonitor pProgressMonitor, final RefactorModel pModel) throws CoreException, OperationCanceledException {
        String[] filenames = new String[]{"*.e4xmi"};
        FileTextSearchScope scope = FileTextSearchScope.newWorkspaceScope((String[])filenames, (boolean)false);
        final HashMap changes = new HashMap();
        TextSearchRequestor searchRequestor = new TextSearchRequestor(){

            public boolean acceptPatternMatch(TextSearchMatchAccess matchAccess) throws CoreException {
                IFile file = matchAccess.getFile();
                TextFileChange change = (TextFileChange)changes.get(file);
                if (change == null) {
                    TextChange textChange = pModel.getTextChange(file);
                    if (textChange != null) {
                        return false;
                    }
                    if (pModel.isProjectRename() && file.getProject().equals((Object)pModel.getOldProject())) {
                        IProject newProject = pModel.getNewProject();
                        IPath oldFile = file.getFullPath().removeFirstSegments(1);
                        IFile newFile = newProject.getFile(oldFile);
                        change = new MovedTextFileChange(file.getName(), newFile, file);
                        change.setEdit((TextEdit)new MultiTextEdit());
                        changes.put(file, change);
                    } else {
                        change = new TextFileChange(file.getName(), file);
                        change.setEdit((TextEdit)new MultiTextEdit());
                        changes.put(file, change);
                    }
                }
                ReplaceEdit edit = new ReplaceEdit(matchAccess.getMatchOffset(), matchAccess.getMatchLength(), pModel.getNewTextCurrentIndex());
                change.addEdit((TextEdit)edit);
                change.addTextEditGroup(new TextEditGroup(RefactorParticipantDelegate.E4_MODEL_CHANGES, (TextEdit)edit));
                return true;
            }
        };
        TextSearchEngine searchEngine = TextSearchEngine.create();
        int count = pModel.getRenameCount();
        while (count > 0) {
            pModel.setIndex(count - 1);
            searchEngine.search((TextSearchScope)scope, searchRequestor, TextSearchEngine.createPattern((String)pModel.getOldTextCurrentIndex(), (boolean)true, (boolean)false), pProgressMonitor);
            --count;
        }
        if (changes.isEmpty()) {
            return null;
        }
        CompositeChange result = new CompositeChange(E4_MODEL_CHANGES);
        for (TextFileChange c : changes.values()) {
            result.add((Change)c);
        }
        return result;
    }
}

