/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.id;

import java.io.IOException;
import java.io.ObjectStreamException;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDString;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.spi.common.id.AbstractCDOID;
import org.eclipse.emf.cdo.spi.common.id.InternalCDOIDObject;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.ref.Interner;

public final class CDOIDObjectStringImpl
extends AbstractCDOID
implements InternalCDOIDObject,
CDOIDString {
    private static final long serialVersionUID = 1L;
    private static final StringInterner INTERNER = new StringInterner();
    private final String value;

    private CDOIDObjectStringImpl(String value) {
        CheckUtil.checkArg((Object)value, (String)"Null not allowed");
        this.value = value;
    }

    private CDOIDObjectStringImpl() {
        this.value = null;
    }

    public void write(CDODataOutput out) throws IOException {
        out.writeString(this.value);
    }

    public String toURIFragment() {
        return this.value;
    }

    public String getStringValue() {
        return this.value;
    }

    public CDOID.Type getType() {
        return CDOID.Type.OBJECT;
    }

    public CDOID.ObjectType getSubType() {
        return CDOID.ObjectType.STRING;
    }

    public boolean isExternal() {
        return false;
    }

    public boolean isObject() {
        return true;
    }

    public boolean isTemporary() {
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return "OID" + this.value;
    }

    protected int doCompareTo(CDOID o) throws ClassCastException {
        return this.value.compareTo(((CDOIDObjectStringImpl)o).value);
    }

    private Object readResolve() throws ObjectStreamException {
        return CDOIDObjectStringImpl.create(this.value);
    }

    private static int getHashCode(String value) {
        return value.hashCode();
    }

    public static CDOIDObjectStringImpl create(String value) {
        return INTERNER.intern(value);
    }

    public static CDOIDObjectStringImpl create(CDODataInput in) throws IOException {
        String value = in.readString();
        return CDOIDObjectStringImpl.create(value);
    }

    /* synthetic */ CDOIDObjectStringImpl(String string, CDOIDObjectStringImpl cDOIDObjectStringImpl) {
        this(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StringInterner
    extends Interner<CDOIDObjectStringImpl> {
        private StringInterner() {
        }

        public synchronized CDOIDObjectStringImpl intern(String value) {
            int hashCode = CDOIDObjectStringImpl.getHashCode(value);
            Interner.Entry entry = this.getEntry(hashCode);
            while (entry != null) {
                CDOIDObjectStringImpl id = (CDOIDObjectStringImpl)entry.get();
                if (id != null && id.value.equals(value)) {
                    return id;
                }
                entry = entry.getNextEntry();
            }
            CDOIDObjectStringImpl id = new CDOIDObjectStringImpl(value, null);
            this.addEntry(this.createEntry(id, hashCode));
            return id;
        }

        protected int hashCode(CDOIDObjectStringImpl id) {
            return CDOIDObjectStringImpl.getHashCode(id.value);
        }
    }
}

