/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.internal;

import org.eclipse.gef.dot.internal.language.color.DotColors;
import org.eclipse.gef.dot.internal.ui.language.internal.DotActivator;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class DotActivatorEx
extends DotActivator {
    protected void initializeImageRegistry(ImageRegistry reg) {
        for (String colorScheme : DotColors.getColorSchemes()) {
            for (String colorName : DotColors.getColorNames((String)colorScheme)) {
                String hex = DotColors.get((String)colorScheme, (String)colorName);
                if (reg.get(hex) != null) continue;
                Image image = this.createImage(hex);
                reg.put(hex, image);
            }
        }
    }

    private Image createImage(String colorCode) {
        Display display = Display.getDefault();
        Image image = new Image((Device)display, 16, 16);
        GC gc = new GC((Drawable)image);
        Color color = this.hex2Rgb(display, colorCode);
        gc.setBackground(color);
        gc.fillRectangle(1, 1, 14, 14);
        gc.setForeground(display.getSystemColor(2));
        gc.drawLine(0, 0, 15, 0);
        gc.drawLine(15, 0, 15, 15);
        gc.drawLine(15, 15, 0, 15);
        gc.drawLine(0, 15, 0, 0);
        gc.dispose();
        return image;
    }

    private Color hex2Rgb(Display display, String colorStr) {
        return new Color((Device)display, Integer.valueOf(colorStr.substring(1, 3), 16).intValue(), Integer.valueOf(colorStr.substring(3, 5), 16).intValue(), Integer.valueOf(colorStr.substring(5, 7), 16).intValue());
    }
}

