/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.quickfix;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.dot.internal.DotAttributes;
import org.eclipse.gef.dot.internal.language.arrowtype.DeprecatedShape;
import org.eclipse.gef.dot.internal.language.clustermode.ClusterMode;
import org.eclipse.gef.dot.internal.language.color.DotColors;
import org.eclipse.gef.dot.internal.language.dir.DirType;
import org.eclipse.gef.dot.internal.language.dot.Attribute;
import org.eclipse.gef.dot.internal.language.dot.EdgeOp;
import org.eclipse.gef.dot.internal.language.dot.EdgeRhsNode;
import org.eclipse.gef.dot.internal.language.dot.EdgeRhsSubgraph;
import org.eclipse.gef.dot.internal.language.layout.Layout;
import org.eclipse.gef.dot.internal.language.outputmode.OutputMode;
import org.eclipse.gef.dot.internal.language.pagedir.Pagedir;
import org.eclipse.gef.dot.internal.language.rankdir.Rankdir;
import org.eclipse.gef.dot.internal.language.ranktype.RankType;
import org.eclipse.gef.dot.internal.language.shape.PolygonBasedNodeShape;
import org.eclipse.gef.dot.internal.language.shape.RecordBasedNodeShape;
import org.eclipse.gef.dot.internal.language.style.ClusterStyle;
import org.eclipse.gef.dot.internal.language.style.EdgeStyle;
import org.eclipse.gef.dot.internal.language.style.NodeStyle;
import org.eclipse.gef.dot.internal.language.terminals.ID;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.quickfix.DefaultQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;

public class DotQuickfixProvider
extends DefaultQuickfixProvider {
    @Fix(value="invalid-edge-operator")
    public void fixInvalidEdgeOperator(Issue issue, IssueResolutionAcceptor acceptor) {
        String[] issueData = issue.getData();
        if (issueData != null && issueData.length > 0) {
            String invalidEdgeOperator = issueData[0];
            final EdgeOp validEdgeOperator = invalidEdgeOperator.equals(EdgeOp.DIRECTED.toString()) ? EdgeOp.UNDIRECTED : EdgeOp.DIRECTED;
            this.provideQuickfix(validEdgeOperator.toString(), "edge operator", issue, acceptor, new ISemanticModification(){

                public void apply(EObject element, IModificationContext context) {
                    EdgeRhsNode edge;
                    if (element instanceof EdgeRhsNode) {
                        edge = (EdgeRhsNode)element;
                        edge.setOp(validEdgeOperator);
                    }
                    if (element instanceof EdgeRhsSubgraph) {
                        edge = (EdgeRhsSubgraph)element;
                        edge.setOp(validEdgeOperator);
                    }
                }
            });
        }
    }

    @Fix(value="redundant-attribute")
    public void fixRedundantAttribute(Issue issue, IssueResolutionAcceptor acceptor) {
        if (issue.getData() == null || issue.getData().length == 0) {
            return;
        }
        String attributeName = issue.getData()[0];
        String label = "Remove '" + attributeName + "' attribute.";
        String description = "Remove the redundant '" + attributeName + "' attribute.";
        ISemanticModification semanticModification = (element, context) -> EcoreUtil.remove((EObject)element);
        acceptor.accept(issue, label, description, null, semanticModification);
    }

    @Fix(value="arrowhead")
    public void fixArrowheadAttributeValue(Issue issue, IssueResolutionAcceptor acceptor) {
        String deprecatedShapeString;
        String validArrowShape;
        String[] issueData = issue.getData();
        if (issueData != null && issueData.length > 0 && (validArrowShape = this.getValidArrowShape(deprecatedShapeString = issueData[0])) != null) {
            this.provideQuickfix(validArrowShape, "edge arrowhead", issue, acceptor);
        }
    }

    @Fix(value="arrowtail")
    public void fixArrowtailAttributeValue(Issue issue, IssueResolutionAcceptor acceptor) {
        String deprecatedShapeString;
        String validArrowShape;
        String[] issueData = issue.getData();
        if (issueData != null && issueData.length > 0 && (validArrowShape = this.getValidArrowShape(deprecatedShapeString = issueData[0])) != null) {
            this.provideQuickfix(validArrowShape, "edge arrowtail", issue, acceptor);
        }
    }

    @Fix(value="clusterrank")
    public void fixClusterRankAttributeValue(Issue issue, IssueResolutionAcceptor acceptor) {
        this.provideQuickfixes(ClusterMode.values(), "graph clusterMode", issue, acceptor);
    }

    @Fix(value="colorscheme")
    public void fixColorschemeAttributeValue(Issue issue, IssueResolutionAcceptor acceptor) {
        this.provideQuickfixes(DotColors.getColorSchemes(), "colorscheme", issue, acceptor);
    }

    @Fix(value="dir")
    public void fixDirAttributeValue(Issue issue, IssueResolutionAcceptor acceptor) {
        this.provideQuickfixes(DirType.values(), "edge dir", issue, acceptor);
    }

    @Fix(value="layout")
    public void fixLayoutAttributeValue(Issue issue, IssueResolutionAcceptor acceptor) {
        this.provideQuickfixes(Layout.values(), "graph layout", issue, acceptor);
    }

    @Fix(value="outputorder")
    public void fixOutputOrderAttributeValue(Issue issue, IssueResolutionAcceptor acceptor) {
        this.provideQuickfixes(OutputMode.values(), "graph outputMode", issue, acceptor);
    }

    @Fix(value="pagedir")
    public void fixPagedirAttributeValue(Issue issue, IssueResolutionAcceptor acceptor) {
        this.provideQuickfixes(Pagedir.values(), "graph pagedir", issue, acceptor);
    }

    @Fix(value="rank")
    public void fixRankAttributeValue(Issue issue, IssueResolutionAcceptor acceptor) {
        this.provideQuickfixes(RankType.values(), "subgraph rankType", issue, acceptor);
    }

    @Fix(value="rankdir")
    public void fixRankdirAttributeValue(Issue issue, IssueResolutionAcceptor acceptor) {
        this.provideQuickfixes(Rankdir.values(), "graph rankdir", issue, acceptor);
    }

    @Fix(value="shape")
    public void fixShapeAttributeValue(Issue issue, IssueResolutionAcceptor acceptor) {
        this.provideQuickfixes(PolygonBasedNodeShape.VALUES, "node shape", issue, acceptor);
        this.provideQuickfixes(RecordBasedNodeShape.VALUES, "node shape", issue, acceptor);
    }

    @Fix(value="style")
    public void fixStyleAttributeValue(Issue issue, IssueResolutionAcceptor acceptor) {
        if (issue.getSeverity() == Severity.WARNING) {
            return;
        }
        String[] issueData = issue.getData();
        if (issueData == null || issueData.length < 2) {
            return;
        }
        DotAttributes.Context attributeContext = DotAttributes.Context.valueOf((String)issueData[1]);
        switch (attributeContext) {
            case GRAPH: 
            case SUBGRAPH: 
            case CLUSTER: {
                this.provideQuickfixes(ClusterStyle.VALUES, "graph style", issue, acceptor);
                break;
            }
            case NODE: {
                this.provideQuickfixes(NodeStyle.VALUES, "node style", issue, acceptor);
                break;
            }
            case EDGE: {
                this.provideQuickfixes(EdgeStyle.VALUES, "edge style", issue, acceptor);
                break;
            }
        }
    }

    private String getValidArrowShape(String deprecatedShapeString) {
        DeprecatedShape deprecatedShape = DeprecatedShape.get((String)deprecatedShapeString);
        if (deprecatedShape == null) {
            return null;
        }
        switch (deprecatedShape) {
            case EDIAMOND: {
                return "odiamond";
            }
            case OPEN: {
                return "vee";
            }
            case HALFOPEN: {
                return "lvee";
            }
            case EMPTY: {
                return "onormal";
            }
            case INVEMPTY: {
                return "oinv";
            }
        }
        return null;
    }

    private void provideQuickfixes(Object[] validValues, String suffix, Issue issue, IssueResolutionAcceptor acceptor) {
        this.provideQuickfixes(Arrays.asList(validValues), suffix, issue, acceptor);
    }

    private void provideQuickfixes(List<?> validValues, String suffix, Issue issue, IssueResolutionAcceptor acceptor) {
        for (Object validValue : validValues) {
            this.provideQuickfix(validValue.toString(), suffix, issue, acceptor);
        }
    }

    private void provideQuickfix(final String validValue, String suffix, Issue issue, IssueResolutionAcceptor acceptor) {
        this.provideQuickfix(validValue, suffix, issue, acceptor, new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) {
                Attribute attribute = (Attribute)element;
                ID.Type type = attribute.getValue().getType();
                ID validValueAsID = ID.fromValue((String)validValue, (ID.Type)type);
                attribute.setValue(validValueAsID);
            }
        });
    }

    private void provideQuickfix(String validValue, String suffix, Issue issue, IssueResolutionAcceptor acceptor, ISemanticModification semanticModification) {
        acceptor.accept(issue, "Replace '" + issue.getData()[0] + "' with '" + validValue + "'.", "Use valid '" + validValue + "' instead of invalid '" + issue.getData()[0] + "' " + suffix + ".", null, semanticModification);
    }
}

