/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.RestOfArgumentsHandler;

@Command(common=true, usage="usage_reset")
class Reset
extends TextBuiltin {
    @Option(name="--soft", usage="usage_resetSoft")
    private boolean soft = false;
    @Option(name="--mixed", usage="usage_resetMixed")
    private boolean mixed = false;
    @Option(name="--hard", usage="usage_resetHard")
    private boolean hard = false;
    @Argument(required=false, index=0, metaVar="metaVar_commitish", usage="usage_resetReference")
    private String commit;
    @Argument(required=false, index=1, metaVar="metaVar_paths")
    @Option(name="--", metaVar="metaVar_paths", handler=RestOfArgumentsHandler.class)
    private List<String> paths = new ArrayList<String>();

    Reset() {
    }

    @Override
    protected void run() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Git git = new Git(this.db);){
                ResetCommand command = git.reset();
                command.setRef(this.commit);
                if (this.paths.size() > 0) {
                    for (String path : this.paths) {
                        command.addPath(path);
                    }
                } else {
                    ResetCommand.ResetType mode = null;
                    if (this.soft) {
                        mode = Reset.selectMode(mode, ResetCommand.ResetType.SOFT);
                    }
                    if (this.mixed) {
                        mode = Reset.selectMode(mode, ResetCommand.ResetType.MIXED);
                    }
                    if (this.hard) {
                        mode = Reset.selectMode(mode, ResetCommand.ResetType.HARD);
                    }
                    if (mode == null) {
                        throw Reset.die(CLIText.get().resetNoMode);
                    }
                    command.setMode(mode);
                }
                command.call();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (GitAPIException e) {
            throw Reset.die(e.getMessage(), (Throwable)e);
        }
    }

    private static ResetCommand.ResetType selectMode(ResetCommand.ResetType mode, ResetCommand.ResetType want) {
        if (mode != null) {
            throw Reset.die("reset modes are mutually exclusive, select one");
        }
        return want;
    }
}

